/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.NpnHandler;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    private int socketBuffer = 9000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String restrictedUserAgents = null;
    private String server;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private int upgradeAsyncWriteBufferSize = 8192;
    protected NpnHandler<S> npnHandler;

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int i) {
        this.connectionUploadTimeout = i;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
    }

    public String getCompressableMimeTypes() {
        return this.getCompressableMimeType();
    }

    public void setCompressableMimeTypes(String valueS) {
        this.setCompressableMimeType(valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int maxExtensionSize) {
        this.maxExtensionSize = maxExtensionSize;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int maxSwallowSize) {
        this.maxSwallowSize = maxSwallowSize;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
    }

    public int getUpgradeAsyncWriteBufferSize() {
        return this.upgradeAsyncWriteBufferSize;
    }

    public void setUpgradeAsyncWriteBufferSize(int upgradeAsyncWriteBufferSize) {
        this.upgradeAsyncWriteBufferSize = upgradeAsyncWriteBufferSize;
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public int getMaxKeepAliveRequests() {
        return this.endpoint.getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.endpoint.setMaxKeepAliveRequests(mkar);
    }

    public void setNpnHandler(String impl) {
        try {
            Class<?> c = Class.forName(impl);
            this.npnHandler = (NpnHandler)c.newInstance();
        }
        catch (Exception ex) {
            this.getLog().warn((Object)("Failed to init light protocol " + impl), (Throwable)ex);
        }
    }

    protected void configureProcessor(AbstractHttp11Processor<S> processor) {
        processor.setAdapter(this.getAdapter());
        processor.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        processor.setKeepAliveTimeout(this.getKeepAliveTimeout());
        processor.setConnectionUploadTimeout(this.getConnectionUploadTimeout());
        processor.setDisableUploadTimeout(this.getDisableUploadTimeout());
        processor.setCompressionMinSize(this.getCompressionMinSize());
        processor.setCompression(this.getCompression());
        processor.setNoCompressionUserAgents(this.getNoCompressionUserAgents());
        processor.setCompressableMimeTypes(this.getCompressableMimeTypes());
        processor.setRestrictedUserAgents(this.getRestrictedUserAgents());
        processor.setSocketBuffer(this.getSocketBuffer());
        processor.setMaxSavePostSize(this.getMaxSavePostSize());
        processor.setServer(this.getServer());
    }
}

