/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.options;

import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;

public class AutomatonNameOption
extends StringOption {
    public AutomatonNameOption() {
        super("Resulting statespace automaton name", "The name of the resulting statespace automaton. [DEFAULT=\"statespace\"]", Character.valueOf('n'), "name", "NAME", null, true, true, "The name of the resulting statespace automaton.", "Name:");
    }

    public static String getAutomatonName(String defaultName) {
        String name = (String)Options.get(AutomatonNameOption.class);
        if (name == null) {
            name = defaultName;
        }
        if (!CifValidationUtils.isValidIdentifier((String)name)) {
            String msg = Strings.fmt((String)"Resulting statespace automaton name \"%s\" is not a valid CIF identifier.", (Object[])new Object[]{name});
            throw new InvalidOptionException(msg);
        }
        return name;
    }
}

