/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class MergeEnums
extends CifWalker
implements CifToCifTransformation {
    private final EnumDecl mergedEnum = CifConstructors.newEnumDecl();
    private final Map<String, EnumLiteral> nameToLitMap = Maps.map();

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Merging enumerations for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        new AddDefaultInitialValues().transform(spec);
        this.walkSpecification(spec);
        if (this.nameToLitMap.isEmpty()) {
            return;
        }
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        Set<String> litNameSet = this.nameToLitMap.keySet();
        List litNames = Sets.sortedstrings(litNameSet);
        EList lits = this.mergedEnum.getLiterals();
        for (String litName : litNames) {
            EnumLiteral lit = this.nameToLitMap.get(litName);
            lits.add(lit);
            String name = lit.getName();
            if (names.contains(name)) {
                String oldName = name;
                name = CifScopeUtils.getUniqueName((String)name, (Set)names, litNameSet);
                lit.setName(name);
                OutputProvider.warn((String)"Enumeration literal \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, name});
            }
            names.add(name);
        }
        String name = "E";
        if (names.contains(name)) {
            String oldName = name;
            name = CifScopeUtils.getUniqueName((String)name, (Set)names, Collections.emptySet());
            OutputProvider.warn((String)"Merged enumeration \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, name});
        }
        this.mergedEnum.setName(name);
        spec.getDeclarations().add((Object)this.mergedEnum);
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        EList decls = comp.getDeclarations();
        Iterator declIter = decls.iterator();
        while (declIter.hasNext()) {
            Declaration decl = (Declaration)declIter.next();
            if (!(decl instanceof EnumDecl)) continue;
            EnumDecl enumDecl = (EnumDecl)decl;
            for (EnumLiteral lit : enumDecl.getLiterals()) {
                this.getLiteral(lit);
            }
            declIter.remove();
        }
    }

    private EnumLiteral getLiteral(EnumLiteral origLiteral) {
        String name = origLiteral.getName();
        EnumLiteral newLiteral = this.nameToLitMap.get(name);
        if (newLiteral == null) {
            newLiteral = CifConstructors.newEnumLiteral();
            newLiteral.setName(name);
            this.nameToLitMap.put(name, newLiteral);
        }
        newLiteral.getAnnotations().addAll((Collection)origLiteral.getAnnotations());
        return newLiteral;
    }

    protected void preprocessEnumLiteralExpression(EnumLiteralExpression litRef) {
        litRef.setLiteral(this.getLiteral(litRef.getLiteral()));
    }

    protected void walkEnumType(EnumType enumType) {
        enumType.setEnum(this.mergedEnum);
    }

    protected void postprocessSwitchExpression(SwitchExpression switchExpr) {
        SwitchCase lastCase;
        if (CifTypeUtils.hasEnumType((CifType)switchExpr.getValue().getType()) && (lastCase = (SwitchCase)Lists.last((List)switchExpr.getCases())).getKey() != null) {
            lastCase.setKey(null);
        }
    }
}

