/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AddDefaultInitialValues
extends CifWalker
implements CifToCifTransformation {
    private List<InternalFunction> funcs = Lists.list();

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Adding default initial values to variables for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
        if (!this.funcs.isEmpty()) {
            Set used = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
            for (InternalFunction func : this.funcs) {
                String name = "_f";
                if (used.contains(name)) {
                    String oldName = name;
                    name = CifScopeUtils.getUniqueName((String)name, (Set)used, Collections.emptySet());
                    OutputProvider.warn((String)"Function \"%s\", introduced for the default value of a function type, is renamed to \"%s\".", (Object[])new Object[]{oldName, name});
                }
                func.setName(name);
                used.add(name);
                spec.getDeclarations().add((Object)func);
            }
        }
    }

    protected void preprocessDiscVariable(DiscVariable var) {
        if (var.eContainer() instanceof FunctionParameter) {
            return;
        }
        if (var.getValue() != null) {
            return;
        }
        Expression defaultValue = CifValueUtils.getDefaultValue((CifType)var.getType(), this.funcs);
        VariableValue vvalue = CifConstructors.newVariableValue();
        vvalue.getValues().add((Object)defaultValue);
        var.setValue(vvalue);
    }

    protected void preprocessContVariable(ContVariable var) {
        if (var.getValue() == null) {
            RealExpression value = CifConstructors.newRealExpression();
            value.setType((CifType)CifConstructors.newRealType());
            value.setValue("0.0");
            var.setValue((Expression)value);
        }
    }
}

