/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.metamodel.chi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperators implements Enumerator
{
    ADDITION(0, "Addition", "Addition"),
    CONJUNCTION(2, "Conjunction", "Conjunction"),
    DISJUNCTION(3, "Disjunction", "Disjunction"),
    DIVISION(4, "Division", "Division"),
    ELEMENT_TEST(5, "ElementTest", "ElementTest"),
    EQUAL(6, "Equal", "Equal"),
    FIELD_PROJECTION(1, "FieldProjection", "FieldProjection"),
    FLOOR_DIVISION(7, "FloorDivision", "FloorDivision"),
    GREATER_EQUAL(8, "GreaterEqual", "GreaterEqual"),
    GREATER_THAN(9, "GreaterThan", "GreaterThan"),
    LESS_THAN(12, "LessThan", "LessThan"),
    LESS_EQUAL(13, "LessEqual", "LessEqual"),
    MODULUS(17, "Modulus", "Modulus"),
    MULTIPLICATION(18, "Multiplication", "Multiplication"),
    NOT_EQUAL(19, "NotEqual", "NotEqual"),
    POWER(20, "Power", "Power"),
    PROJECTION(25, "Projection", "Projection"),
    SUBSET(22, "Subset", "Subset"),
    SUBTRACTION(23, "Subtraction", "Subtraction");

    public static final int ADDITION_VALUE = 0;
    public static final int CONJUNCTION_VALUE = 2;
    public static final int DISJUNCTION_VALUE = 3;
    public static final int DIVISION_VALUE = 4;
    public static final int ELEMENT_TEST_VALUE = 5;
    public static final int EQUAL_VALUE = 6;
    public static final int FIELD_PROJECTION_VALUE = 1;
    public static final int FLOOR_DIVISION_VALUE = 7;
    public static final int GREATER_EQUAL_VALUE = 8;
    public static final int GREATER_THAN_VALUE = 9;
    public static final int LESS_THAN_VALUE = 12;
    public static final int LESS_EQUAL_VALUE = 13;
    public static final int MODULUS_VALUE = 17;
    public static final int MULTIPLICATION_VALUE = 18;
    public static final int NOT_EQUAL_VALUE = 19;
    public static final int POWER_VALUE = 20;
    public static final int PROJECTION_VALUE = 25;
    public static final int SUBSET_VALUE = 22;
    public static final int SUBTRACTION_VALUE = 23;
    private static final BinaryOperators[] VALUES_ARRAY;
    public static final List<BinaryOperators> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperators[]{ADDITION, CONJUNCTION, DISJUNCTION, DIVISION, ELEMENT_TEST, EQUAL, FIELD_PROJECTION, FLOOR_DIVISION, GREATER_EQUAL, GREATER_THAN, LESS_THAN, LESS_EQUAL, MODULUS, MULTIPLICATION, NOT_EQUAL, POWER, PROJECTION, SUBSET, SUBTRACTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperators get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperators result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperators getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperators result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperators get(int value) {
        switch (value) {
            case 0: {
                return ADDITION;
            }
            case 2: {
                return CONJUNCTION;
            }
            case 3: {
                return DISJUNCTION;
            }
            case 4: {
                return DIVISION;
            }
            case 5: {
                return ELEMENT_TEST;
            }
            case 6: {
                return EQUAL;
            }
            case 1: {
                return FIELD_PROJECTION;
            }
            case 7: {
                return FLOOR_DIVISION;
            }
            case 8: {
                return GREATER_EQUAL;
            }
            case 9: {
                return GREATER_THAN;
            }
            case 12: {
                return LESS_THAN;
            }
            case 13: {
                return LESS_EQUAL;
            }
            case 17: {
                return MODULUS;
            }
            case 18: {
                return MULTIPLICATION;
            }
            case 19: {
                return NOT_EQUAL;
            }
            case 20: {
                return POWER;
            }
            case 25: {
                return PROJECTION;
            }
            case 22: {
                return SUBSET;
            }
            case 23: {
                return SUBTRACTION;
            }
        }
        return null;
    }

    private BinaryOperators(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

