/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExplorerState
extends BaseState {
    public ExplorerState(BaseState prev) {
        super(prev.explorer, (Location[])prev.locations.clone(), (Object[])prev.values.clone());
    }

    @Override
    public Object getVarValue(PositionObject var) {
        return this.values[this.explorer.indices.get(var)];
    }

    @Override
    public void setVarValue(PositionObject var, Object value) {
        Assert.notNull((Object)value);
        int index = this.explorer.indices.get(var);
        this.values[index] = value;
    }

    @Override
    public Location getCurrentLocation(int autIndex) {
        return this.locations[autIndex];
    }

    @Override
    public Expression getAlgExpression(AlgVariable algVar) {
        return this.explorer.algVariables.get(algVar).getExpression(this.locations);
    }

    @Override
    public boolean isInitial() {
        return false;
    }

    @Override
    public boolean isMarked() {
        for (Expression expr : this.explorer.markeds) {
            try {
                if (((Boolean)this.eval(expr, null)).booleanValue()) continue;
                return false;
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute marker predicate \"%s\" for state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), this.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        Location[] locationArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            if (loc.getMarkeds().isEmpty()) {
                return false;
            }
            for (Expression expr : loc.getMarkeds()) {
                try {
                    if (((Boolean)this.eval(expr, null)).booleanValue()) continue;
                    return false;
                }
                catch (CifEvalException ex) {
                    String msg = Strings.fmt((String)"Failed to compute marker predicate \"%s\" in %s, for state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), CifTextUtils.getLocationText2((Location)loc), this.toString()});
                    throw new InvalidModelException(msg, (Throwable)ex);
                }
            }
            ++n2;
        }
        return true;
    }
}

