/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.code.Upf9Decoder;

public class ByteArray {
    private final byte[] data;
    private final int length;

    private ByteArray(byte[] data, int length) {
        this.data = data;
        this.length = length;
    }

    public static ByteArray from(byte[] input) {
        return new ByteArray(input, input.length);
    }

    public String toUFT8String() throws UnsupportedEncodingException {
        return new String(this.data, 0, this.length, StandardCharsets.UTF_8);
    }

    public String toUPF9String() throws IOException {
        return Upf9Decoder.decodeString(this.data, this.length);
    }

    public int getByteAt(int i) {
        return this.data[i];
    }

    public int length() {
        return this.length;
    }
}

