/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.table.Column;
import org.h2.value.Value;

public class IndexCondition {
    public static final int EQUALITY = 1;
    public static final int START = 2;
    public static final int END = 4;
    public static final int RANGE = 6;
    public static final int ALWAYS_FALSE = 8;
    private Column column;
    private Expression expression;
    private int compareType;

    public IndexCondition(int n, ExpressionColumn expressionColumn, Expression expression) {
        this.compareType = n;
        this.column = expressionColumn == null ? null : expressionColumn.getColumn();
        this.expression = expression;
    }

    public Value getCurrentValue(Session session) throws SQLException {
        return this.expression.getValue(session);
    }

    public String getSQL() {
        if (this.compareType == 8) {
            return "FALSE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.column.getSQL());
        switch (this.compareType) {
            case 0: {
                stringBuilder.append(" = ");
                break;
            }
            case 1: {
                stringBuilder.append(" >= ");
                break;
            }
            case 2: {
                stringBuilder.append(" > ");
                break;
            }
            case 3: {
                stringBuilder.append(" <= ");
                break;
            }
            case 4: {
                stringBuilder.append(" < ");
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.compareType);
            }
        }
        stringBuilder.append(this.expression.getSQL());
        return stringBuilder.toString();
    }

    public int getMask() {
        switch (this.compareType) {
            case 8: {
                return 8;
            }
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 4;
            }
        }
        throw Message.throwInternalError("type=" + this.compareType);
    }

    public boolean isAlwaysFalse() {
        return this.compareType == 8;
    }

    public boolean isStart() {
        switch (this.compareType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnd() {
        switch (this.compareType) {
            case 0: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isEvaluatable() {
        return this.expression.isEverything(3);
    }
}

