/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared;

import java.util.Map;
import org.apache.jena.assembler.JA;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.RSS;
import org.apache.jena.vocabulary.VCARD;
import org.apache.jena.vocabulary.XSD;

public interface PrefixMapping {
    public static final PrefixMapping Standard = Factory.create().setNsPrefix("rdfs", RDFS.getURI()).setNsPrefix("rdf", RDF.getURI()).setNsPrefix("dc", DC_11.getURI()).setNsPrefix("owl", OWL.getURI()).setNsPrefix("xsd", XSD.getURI()).lock();
    public static final PrefixMapping Extended = Factory.create().setNsPrefixes(Standard).setNsPrefix("rss", RSS.getURI()).setNsPrefix("vcard", VCARD.getURI()).setNsPrefix("ja", JA.getURI()).setNsPrefix("eg", "http://www.example.org/").lock();

    public PrefixMapping setNsPrefix(String var1, String var2);

    public PrefixMapping removeNsPrefix(String var1);

    public PrefixMapping clearNsPrefixMap();

    public PrefixMapping setNsPrefixes(PrefixMapping var1);

    public PrefixMapping setNsPrefixes(Map<String, String> var1);

    public PrefixMapping withDefaultMappings(PrefixMapping var1);

    public String getNsPrefixURI(String var1);

    public String getNsURIPrefix(String var1);

    public Map<String, String> getNsPrefixMap();

    public String expandPrefix(String var1);

    public String shortForm(String var1);

    public String qnameFor(String var1);

    public PrefixMapping lock();

    default public boolean hasNoMappings() {
        return this.numPrefixes() == 0;
    }

    public int numPrefixes();

    public boolean samePrefixMappingAs(PrefixMapping var1);

    public static class Factory {
        public static PrefixMapping create() {
            return new PrefixMappingImpl();
        }

        static {
            JenaSystem.init();
        }
    }

    public static class JenaLockedException
    extends JenaException {
        public JenaLockedException(PrefixMapping pm) {
            super(pm.toString());
        }
    }

    public static class IllegalPrefixException
    extends JenaException {
        public IllegalPrefixException(String prefixName) {
            super(prefixName);
        }
    }
}

