/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.EltStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;

public class AsyncParserBuilder {
    private static final int dftChunkSize = 100000;
    private static final int dftQueueSize = 10;
    private int chunkSize = 100000;
    private int queueSize = 10;
    private boolean daemonMode = true;
    private Predicate<EltStreamRDF> prematureDispatch = null;
    private List<RDFParserBuilder> sources = Collections.emptyList();

    public AsyncParserBuilder() {
    }

    public AsyncParserBuilder(List<RDFParserBuilder> sources) {
        this();
        this.sources = List.copyOf(sources);
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public AsyncParserBuilder setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public AsyncParserBuilder setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public boolean isDaemonMode() {
        return this.daemonMode;
    }

    public AsyncParserBuilder setDaemonMode(boolean daemonMode) {
        this.daemonMode = daemonMode;
        return this;
    }

    public AsyncParserBuilder setPrematureDispatch(Predicate<EltStreamRDF> prematureDispatch) {
        this.prematureDispatch = prematureDispatch;
        return this;
    }

    public Predicate<EltStreamRDF> getPrematureDispatch() {
        return this.prematureDispatch;
    }

    public List<RDFParserBuilder> getSources() {
        return this.sources;
    }

    public AsyncParserBuilder setSources(List<RDFParserBuilder> sources) {
        this.sources = List.copyOf(sources);
        return this;
    }

    public AsyncParserBuilder mutateSources(Consumer<RDFParserBuilder> mutator) {
        for (RDFParserBuilder source : this.sources) {
            mutator.accept(source);
        }
        return this;
    }

    private IteratorCloseable<EltStreamRDF> asyncParseElements() {
        Objects.requireNonNull(this.sources);
        ArrayBlockingQueue<List<EltStreamRDF>> queue = new ArrayBlockingQueue<List<EltStreamRDF>>(this.queueSize);
        Runnable closeAction = AsyncParser.startParserThread(AsyncParser.LOG, this.sources, queue, this.chunkSize, this.prematureDispatch, this.daemonMode);
        IteratorCloseable<List> blocks = AsyncParser.blockingIterator(closeAction, queue, x -> x == AsyncParser.END);
        IteratorCloseable elements = (IteratorCloseable)Iter.flatMap(blocks, x -> x.iterator());
        return elements;
    }

    public IteratorCloseable<Triple> asyncParseTriples() {
        return Iter.iter(this.asyncParseElements()).map(AsyncParser.elt2Triple).removeNulls();
    }

    public IteratorCloseable<Quad> asyncParseQuads() {
        return Iter.iter(this.asyncParseElements()).map(AsyncParser.elt2Quad).removeNulls();
    }

    public Stream<EltStreamRDF> streamElements() {
        return Iter.asStream(this.asyncParseElements());
    }

    public Stream<Triple> streamTriples() {
        return Iter.asStream(this.asyncParseTriples());
    }

    public Stream<Quad> streamQuads() {
        return Iter.asStream(this.asyncParseQuads());
    }

    public Runnable asyncParseSources(StreamRDF output) {
        Logger LOG1 = AsyncParser.LOG;
        Logger LOG2 = AsyncParser.LOG;
        ArrayBlockingQueue<List<EltStreamRDF>> queue = new ArrayBlockingQueue<List<EltStreamRDF>>(this.queueSize);
        Runnable closeAction = AsyncParser.startParserThread(LOG1, this.sources, queue, this.chunkSize, this.prematureDispatch, this.daemonMode);
        AsyncParser.receiver(closeAction, LOG2, queue, output);
        return closeAction;
    }
}

