/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands;

import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandObserver;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandStack;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreCommandNotifier;
import org.eclipse.emf.emfstore.internal.client.model.util.AbstractEMFStoreCommand;

public class EMFStoreBasicCommandStack
extends BasicCommandStack
implements ESCommandStack {
    private final EMFStoreCommandNotifier notifier = new EMFStoreCommandNotifier();
    private Command currentCommand;

    protected void handleError(Exception exception) {
        this.notifier.notifiyListenersAboutCommandFailed(this.currentCommand, exception);
        this.currentCommand = null;
    }

    public void undo() {
        if (this.canUndo()) {
            this.notifier.notifiyListenersAboutStart(this.mostRecentCommand);
            super.undo();
            this.rethrowComamndInCaseOfError(this.mostRecentCommand);
            this.notifier.notifiyListenersAboutCommandCompleted(this.mostRecentCommand);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            this.notifier.notifiyListenersAboutStart(this.mostRecentCommand);
            super.redo();
            this.rethrowComamndInCaseOfError(this.mostRecentCommand);
            this.notifier.notifiyListenersAboutCommandCompleted(this.mostRecentCommand);
        }
    }

    public void execute(Command command) {
        if (this.currentCommand == null) {
            this.currentCommand = command;
            this.notifier.notifiyListenersAboutStart(command);
        }
        super.execute(command);
        this.rethrowComamndInCaseOfError(command);
        if (this.currentCommand == command) {
            if (this.mostRecentCommand == command) {
                this.notifier.notifiyListenersAboutCommandCompleted(command);
            }
            this.currentCommand = null;
        }
    }

    private void rethrowComamndInCaseOfError(Command command) {
        AbstractEMFStoreCommand emfStoreCmd;
        if (command instanceof AbstractEMFStoreCommand && !(emfStoreCmd = (AbstractEMFStoreCommand)command).shouldIgnoreExceptions() && emfStoreCmd.getRuntimeException() != null) {
            throw emfStoreCmd.getRuntimeException();
        }
    }

    public void addCommandStackObserver(ESCommandObserver observer) {
        this.notifier.addCommandStackObserver(observer);
    }

    public void removeCommandStackObserver(ESCommandObserver observer) {
        this.notifier.removeCommandStackObserver(observer);
    }
}

