/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emfforms.internal.editor.Activator;
import org.eclipse.emfforms.internal.editor.toolbaractions.LoadEcoreAction;
import org.eclipse.emfforms.internal.editor.ui.EditorToolBar;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultDeleteActionBuilder;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.editor.IToolbarAction;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DeleteActionBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailMenuListener;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.ActionCollector;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class GenericEditor
extends EditorPart
implements IEditingDomainProvider {
    private static final String ITOOLBAR_ACTIONS_ID = "org.eclipse.emfforms.editor.toolbarActions";
    private ResourceSet resourceSet;
    private final BasicCommandStack commandStack = new BasicCommandStack();
    private TreeMasterDetailComposite rootView;
    private boolean filesChangedWithConflict;
    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == GenericEditor.this && GenericEditor.this.isDirty() && GenericEditor.this.filesChangedWithConflict && GenericEditor.this.discardChanges()) {
                for (Resource r : GenericEditor.this.resourceSet.getResources()) {
                    r.unload();
                    try {
                        r.load(null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    private final IResourceChangeListener resourceChangeListener = new EcoreResourceChangeListener();

    public void doSave(IProgressMonitor monitor) {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        if (ResourceSetHelpers.save(this.resourceSet)) {
            this.commandStack.saveIsDone();
            this.firePropertyChange(257);
            this.filesChangedWithConflict = false;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    protected void handleResourceChange(Collection<Resource> changedResources, Collection<Resource> removedResources) {
        if (!this.isDirty()) {
            this.resourceSet.getResources().removeAll(removedResources);
            for (Resource changed : changedResources) {
                changed.unload();
                try {
                    changed.load(null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } else {
            this.filesChangedWithConflict = true;
        }
    }

    private boolean discardChanges() {
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"File Changed", (String)"The currently opened files were changed. Do you want to discard the changes and reload the file?");
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        int result = saveAsDialog.open();
        if (result == 0) {
            IPath path = saveAsDialog.getResult();
            this.setPartName(path.lastSegment());
            ((Resource)this.resourceSet.getResources().get(0)).setURI(URI.createFileURI((String)path.toOSString()));
            this.doSave(null);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                GenericEditor.this.firePropertyChange(257);
            }
        });
        ((IContextService)site.getService(IContextService.class)).activateContext(this.getContextId());
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    protected String getContextId() {
        return "org.eclipse.emfforms.editor.context";
    }

    public boolean isDirty() {
        return this.commandStack.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.resourceSet = this.loadResource(this.getEditorInput());
        parent.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        parent.setBackgroundMode(2);
        this.rootView = this.createRootView(parent, this.getEditorTitle(), this.modifyEditorInput(this.resourceSet), this.getToolbarActions(), this.getCreateElementCallback());
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.rootView.getSelectionProvider());
    }

    private TreeMasterDetailComposite createRootView(Composite parent, String editorTitle, Object editorInput, List<Action> toolbarActions, CreateElementCallback createElementCallback) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData toolbarLayoutData = new FormData();
        toolbarLayoutData.left = new FormAttachment(0);
        toolbarLayoutData.right = new FormAttachment(100);
        toolbarLayoutData.top = new FormAttachment(0);
        EditorToolBar toolbar = new EditorToolBar(composite, 0, editorTitle, toolbarActions);
        toolbar.setLayoutData(toolbarLayoutData);
        FormData treeMasterDetailLayoutData = new FormData();
        treeMasterDetailLayoutData.top = new FormAttachment((Control)toolbar, 5);
        treeMasterDetailLayoutData.left = new FormAttachment(0);
        treeMasterDetailLayoutData.right = new FormAttachment(100);
        treeMasterDetailLayoutData.bottom = new FormAttachment(100);
        TreeMasterDetailComposite treeMasterDetail = this.createTreeMasterDetail(composite, editorInput, createElementCallback);
        treeMasterDetail.setLayoutData((Object)treeMasterDetailLayoutData);
        return treeMasterDetail;
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, final CreateElementCallback createElementCallback) {
        TreeMasterDetailComposite treeMasterDetail = TreeMasterDetailSWTFactory.fillDefaults((Composite)composite, (int)0, (Object)editorInput).customizeCildCreation(createElementCallback).customizeMenu(new MenuProvider(){

            public Menu getMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                List masterDetailActions = ActionCollector.newList().addCutAction(editingDomain).addCopyAction(editingDomain).addPasteAction(editingDomain).getList();
                menuMgr.addMenuListener((IMenuListener)new TreeMasterDetailMenuListener(new ChildrenDescriptorCollector(), menuMgr, treeViewer, editingDomain, (Collection)masterDetailActions, createElementCallback, (DeleteActionBuilder)new DefaultDeleteActionBuilder()));
                Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
                return menu;
            }
        }).create();
        return treeMasterDetail;
    }

    protected Object modifyEditorInput(ResourceSet resourceSet) {
        return resourceSet;
    }

    protected ResourceSet loadResource(IEditorInput editorInput) {
        FileEditorInput fei = (FileEditorInput)editorInput;
        return ResourceSetHelpers.loadResourceSetWithProxies(URI.createPlatformResourceURI((String)fei.getFile().getFullPath().toOSString(), (boolean)false), this.commandStack);
    }

    public void setFocus() {
    }

    protected boolean hasShortcuts() {
        return false;
    }

    protected String getEditorTitle() {
        return "Model Editor";
    }

    protected CreateElementCallback getCreateElementCallback() {
        return null;
    }

    public EditingDomain getEditingDomain() {
        if (this.rootView == null) {
            return null;
        }
        return this.rootView.getEditingDomain();
    }

    private List<Action> getToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add(new LoadEcoreAction(this.resourceSet));
        result.addAll(this.readToolbarActions());
        return result;
    }

    private List<Action> readToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void setSelection(ISelection selection) {
                if (GenericEditor.this.rootView == null) {
                    return;
                }
                GenericEditor.this.rootView.getSelectionProvider().setSelection(selection);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException();
            }

            public ISelection getSelection() {
                if (GenericEditor.this.rootView == null) {
                    return new StructuredSelection();
                }
                return GenericEditor.this.rootView.getSelectionProvider().getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException();
            }
        };
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return result;
        }
        IConfigurationElement[] config = registry.getConfigurationElementsFor(ITOOLBAR_ACTIONS_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IToolbarAction action;
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("toolbarAction");
                if (o instanceof IToolbarAction && (action = (IToolbarAction)o).canExecute(this.resourceSet)) {
                    result.add(action.getAction(this.resourceSet, selectionProvider));
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
        }
        return result;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private final class EcoreResourceChangeListener
    implements IResourceChangeListener {
        private EcoreResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final ArrayList<Resource> changedResources = new ArrayList<Resource>();
            final ArrayList<Resource> removedResources = new ArrayList<Resource>();
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4)) {
                            Resource resource = GenericEditor.this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false);
                            if (resource != null) {
                                if (delta.getKind() == 2) {
                                    removedResources.add(resource);
                                } else {
                                    changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
            }
            GenericEditor.this.handleResourceChange(changedResources, removedResources);
        }
    }
}

