/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ReadLineCapable;

public abstract class AbstractOperationEmitter
implements Closeable {
    private final Direction direction;
    private final File operationsFile;
    private ReadLineCapable reader;
    private final List<Long> forwardOffsets = new ArrayList<Long>();
    private final List<Long> backwardsOffsets = new ArrayList<Long>();
    private int currentOpIndex;
    private long startOffset;

    public AbstractOperationEmitter(Direction direction, File file) {
        this.direction = direction;
        this.operationsFile = file;
        this.determineOperationOffsets();
        this.currentOpIndex = direction == Direction.Forward ? 0 : this.backwardsOffsets.size() - 1;
        this.initReader();
    }

    protected final Direction getDirection() {
        return this.direction;
    }

    private void determineOperationOffsets() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.operationsFile, "r");
            InputStream inputStream = Channels.newInputStream(randomAccessFile.getChannel());
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            long filePointer = 0L;
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    long filePointerAfterReadline = randomAccessFile.getFilePointer();
                    randomAccessFile.seek(filePointer += (long)line.getBytes().length);
                    int byteAfterLine = randomAccessFile.read();
                    if (byteAfterLine == 13) {
                        ++filePointer;
                        byteAfterLine = randomAccessFile.read();
                    }
                    if (byteAfterLine == 10) {
                        ++filePointer;
                    }
                    randomAccessFile.seek(filePointerAfterReadline);
                    if (line.contains("<org.eclipse.emf.emfstore.internal.server.model.versioning:ChangePackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning=\"http://eclipse.org/emf/emfstore/server/model/versioning\" xmlns:org.eclipse.emf.emfstore.internal.server.model.versioning.operations=\"http://eclipse.org/emf/emfstore/server/model/versioning/operations\">")) {
                        this.startOffset = filePointer;
                        continue;
                    }
                    if (line.contains("<operations>")) {
                        this.forwardOffsets.add(filePointer);
                        continue;
                    }
                    if (!line.contains("</operations>")) continue;
                    this.backwardsOffsets.add(filePointer);
                }
            }
            finally {
                bufferedReader.close();
                randomAccessFile.close();
            }
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }

    private void initReader() {
        try {
            this.reader = this.getDirection() == Direction.Forward ? ReadLineCapable.INSTANCE.create(new BufferedReader(new FileReader(this.operationsFile))) : ReadLineCapable.INSTANCE.create(new ReversedLinesFileReader(this.operationsFile));
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }

    public long getOffset() {
        if (this.currentOpIndex < 0) {
            return this.startOffset;
        }
        return this.backwardsOffsets.get(this.currentOpIndex);
    }

    private static void writeDummyResourceToStream(PipedOutputStream pos) throws IOException {
        pos.write("<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ecore:EObject xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"/>".getBytes());
    }

    protected final void readForward(PipedOutputStream pos) {
        try {
            try {
                boolean operationsFound = false;
                boolean withinOperationsElement = false;
                boolean isForwardDir = this.getDirection() == Direction.Forward;
                String closingTag = this.getClosingTag(isForwardDir);
                String line = this.reader.readLine();
                while (line != null && !line.contains(closingTag)) {
                    if (line.contains(this.getOpeningTag(isForwardDir))) {
                        withinOperationsElement = true;
                    } else if (withinOperationsElement) {
                        operationsFound = true;
                        pos.write(line.getBytes());
                    }
                    line = this.reader.readLine();
                }
                if (line != null) {
                    withinOperationsElement = false;
                }
                if (!operationsFound) {
                    AbstractOperationEmitter.writeDummyResourceToStream(pos);
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    pos.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    private void readForward(DataInput reader, PipedOutputStream pos) {
        try {
            try {
                boolean operationsFound = false;
                boolean withinOperationsElement = true;
                String closingTag = this.getClosingTag(true);
                String line = reader.readLine();
                while (line != null && !line.contains(closingTag)) {
                    if (line.contains(this.getOpeningTag(true))) {
                        withinOperationsElement = true;
                    } else if (withinOperationsElement && line.length() > 0) {
                        operationsFound = true;
                        pos.write(line.getBytes());
                    }
                    line = reader.readLine();
                }
                if (!operationsFound) {
                    AbstractOperationEmitter.writeDummyResourceToStream(pos);
                }
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    pos.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    protected final void readBackward(PipedOutputStream pos) {
        if (this.currentOpIndex < 0) {
            try {
                AbstractOperationEmitter.writeDummyResourceToStream(pos);
                pos.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
            return;
        }
        long offset = this.forwardOffsets.get(this.currentOpIndex);
        --this.currentOpIndex;
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(this.operationsFile, "r");
                raf.skipBytes((int)offset);
                this.readForward(raf, pos);
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
                try {
                    raf.close();
                }
                catch (IOException ex2) {
                    ModelUtil.logException((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException ex) {
                ModelUtil.logException((Throwable)ex);
            }
        }
    }

    private String getClosingTag(boolean isForward) {
        return isForward ? "</operations>" : "<operations>";
    }

    private String getOpeningTag(boolean isForward) {
        return isForward ? "<operations>" : "</operations>";
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            ModelUtil.logException((Throwable)ex);
        }
    }
}

