/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.views;

import org.eclipse.emf.ecp.ui.actions.RefreshViewerAction;
import org.eclipse.emf.ecp.ui.e3.Messages;
import org.eclipse.emf.ecp.ui.platform.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public abstract class TreeView
extends ViewPart
implements ISelectionProvider,
ISetSelectionTarget {
    public static final String GLOBAL_ADDITIONS = "global_additions";
    private final String id;
    private TreeViewer viewer;
    private Action refreshAction;

    public TreeView(String id) {
        this.id = id;
    }

    public final String getID() {
        return this.id;
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    public final Action getRefreshAction() {
        return this.refreshAction;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.setSelectionProvider((ISelectionProvider)this);
    }

    public final void createPartControl(Composite parent) {
        try {
            this.viewer = this.createViewer(parent);
            if (this.viewer == null) {
                throw new IllegalStateException(Messages.TreeView_Exception_ViewerNotCreated);
            }
            this.refreshAction = new RefreshViewerAction((Viewer)this.viewer);
            this.hookContextMenu();
            this.hookDoubleClickAction();
            this.contributeToActionBars();
        }
        catch (RuntimeException ex) {
            Activator.log(ex);
            throw ex;
        }
        catch (Error ex) {
            Activator.log(ex);
            throw ex;
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public IStructuredSelection getSelection() {
        if (this.viewer != null) {
            return (IStructuredSelection)this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)this.getTitle(), (String)message);
    }

    protected ILabelDecorator createLabelDecorator() {
        return PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    protected abstract TreeViewer createViewer(Composite var1);

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(GLOBAL_ADDITIONS));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
    }

    protected void doubleClicked(DoubleClickEvent event) {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeView.this.doubleClicked(event);
            }
        });
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeView.this.fillContextMenu(manager);
            }
        });
        Control control = this.viewer.getControl();
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(this.getID(), manager, (ISelectionProvider)this.viewer);
    }
}

