/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.packs.core.data;

import ilg.gnumcueclipse.packs.core.Preferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.console.MessageConsoleStream;

public class PacksStorage {
    public static final String CACHE_FOLDER = ".cache";
    public static final String CONTENT_FILE_NAME_PREFIX = ".content_";
    public static final String CONTENT_FILE_NAME_SUFFIX = ".xml";
    public static final String CONTENT_XML_VERSION = "1.1";
    public static final String INSTALLED_DEVICES_FILE_NAME = ".installed_devices_boards_books.xml";
    private static IPath fgFolderPath = null;
    private static final int TIME_OUT = 0;

    public static File getFileObject(String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static File getCachedFileObject(String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(CACHE_FOLDER).append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static File getPackageFileObject(String vendor, String packageName, String version, String name) throws IOException {
        IPath path = PacksStorage.getFolderPath().append(vendor).append(packageName).append(version).append(name);
        File file = path.toFile();
        if (file == null) {
            throw new IOException(String.valueOf(name) + " File object null.");
        }
        return file;
    }

    public static synchronized IPath getFolderPath() throws IOException {
        if (fgFolderPath == null) {
            fgFolderPath = new Path(PacksStorage.getFolderPathString());
        }
        return fgFolderPath;
    }

    public static String getFolderPathString() throws IOException {
        IPreferenceStore store = Preferences.getPreferenceStore();
        String folderPath = store.getString("packs.folder.path").trim();
        if (folderPath == null) {
            throw new IOException("Missing folder path.");
        }
        if (folderPath.endsWith(String.valueOf('/'))) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        if (folderPath.length() == 0) {
            throw new IOException("Missing folder path.");
        }
        return folderPath;
    }

    public static String makeCachedPdscName(String pdscName, String version) {
        String s = pdscName;
        int ix = s.lastIndexOf(46);
        if (ix > 0) {
            s = String.valueOf(s.substring(0, ix)) + "." + version + s.substring(ix);
        }
        return s;
    }

    public static long getPackSize(String packName, URL url, MessageConsoleStream out) throws IOException {
        long sz;
        File f = PacksStorage.getCachedFileObject(packName);
        if (f.isFile()) {
            long sz2 = f.length();
            out.println("\"" + packName + "\" already installed, size is " + String.valueOf(sz2) + " bytes.");
            return sz2;
        }
        String cachedName = "." + packName + ".size";
        f = PacksStorage.getCachedFileObject(cachedName);
        if (f.isFile()) {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String str = br.readLine();
            br.close();
            if (str != null && !str.isEmpty()) {
                try {
                    long sz3 = Long.valueOf(str);
                    out.println("Size of \"" + packName + "\" retrieved from cache is " + String.valueOf(sz3) + " bytes.");
                    return sz3;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if ((sz = PacksStorage.getRemoteFileSize(packName, url, out)) >= 0L) {
            FileWriter fr = new FileWriter(f);
            fr.write(String.valueOf(sz));
            fr.close();
            out.println("Value " + String.valueOf(sz) + " cached into \"" + f.getCanonicalPath() + "\".");
        }
        return sz;
    }

    public static long getRemoteFileSize(String packName, URL url, MessageConsoleStream out) throws IOException {
        long length;
        URLConnection connection;
        block7: {
            int responseCode;
            HttpURLConnection httpURLConnection;
            while (true) {
                out.println("Getting size of \"" + url + "\"...");
                connection = url.openConnection();
                if (!(connection instanceof HttpURLConnection)) break block7;
                connection.setConnectTimeout(0);
                connection.setReadTimeout(0);
                httpURLConnection = (HttpURLConnection)connection;
                responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) break block7;
                if (responseCode != 302 && responseCode != 301 && responseCode != 303) break;
                String newUrl = connection.getHeaderField("Location");
                url = new URL(newUrl);
            }
            if (responseCode == 404) {
                httpURLConnection.disconnect();
                throw new FileNotFoundException("File \"" + url + "\" not found (" + responseCode + ").");
            }
            httpURLConnection.disconnect();
            throw new FileNotFoundException("Failed to open connection, response code " + responseCode);
        }
        if ((length = (long)connection.getContentLength()) < 0L) {
            int bytesRead;
            InputStream input = connection.getInputStream();
            FileOutputStream output = null;
            if (packName != null && !packName.isEmpty()) {
                File f = PacksStorage.getCachedFileObject(packName);
                output = new FileOutputStream(f);
                out.println("Writing \"" + f.getCanonicalPath() + "\"...");
            }
            int totalBytes = 0;
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                totalBytes += bytesRead;
                if (output == null) continue;
                ((OutputStream)output).write(buf, 0, bytesRead);
            }
            input.close();
            if (output != null) {
                ((OutputStream)output).close();
            }
            length = totalBytes;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
        return length;
    }

    public static int getRemoteFileSize(URL url, MessageConsoleStream out) throws IOException {
        return (int)PacksStorage.getRemoteFileSize(null, url, out);
    }
}

