/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.preferences;

import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.arm.core.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.arm.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.managedbuild.cross.arm.ui.preferences.ToolchainsFieldEditor;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.ui.LabelFakeFieldEditor;
import org.eclipse.embedcdt.ui.XpackDirectoryNotStrictFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GlobalToolchainsPathsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.embedcdt.internal.managedbuild.cross.arm.ui.preferencePage.globalToolchainsPaths";
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();

    public GlobalToolchainsPathsPreferencesPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.embedcdt.managedbuild.cross.arm.core"));
        this.setDescription(Messages.GlobalToolchainsPathsPreferencesPage_description);
    }

    public void init(IWorkbench workbench) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("arm.GlobalToolchainsPathsPreferencesPage.init()");
        }
    }

    protected void createFieldEditors() {
        ToolchainsFieldEditor toolchainNameField = new ToolchainsFieldEditor("toolchain.id", Messages.ToolchainName_label, this.getFieldEditorParent());
        this.addField((FieldEditor)toolchainNameField);
        HashSet<ToolchainDefinition> toolchains = new HashSet<ToolchainDefinition>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)projects[i]);
            if (configs != null) {
                int j = 0;
                while (j < configs.length) {
                    block20: {
                        IToolChain toolchain = configs[j].getToolChain();
                        if (toolchain != null) {
                            IOption optionName;
                            IOption optionId = toolchain.getOptionBySuperClassId("ilg.gnuarmeclipse.managedbuild.cross.option.toolchain.id");
                            if (optionId != null) {
                                try {
                                    String toolchainId = optionId.getStringValue();
                                    int ix = ToolchainDefinition.findToolchainById((String)toolchainId);
                                    toolchains.add(ToolchainDefinition.getToolchain((int)ix));
                                    break block20;
                                }
                                catch (BuildException toolchainId) {
                                }
                                catch (IndexOutOfBoundsException toolchainId) {
                                    // empty catch block
                                }
                            }
                            if ((optionName = toolchain.getOptionBySuperClassId("ilg.gnuarmeclipse.managedbuild.cross.option.toolchain.name")) != null) {
                                try {
                                    String toolchainName = optionName.getStringValue();
                                    int ix = ToolchainDefinition.findToolchainByName((String)toolchainName);
                                    toolchains.add(ToolchainDefinition.getToolchain((int)ix));
                                }
                                catch (BuildException buildException) {
                                }
                                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainId = this.fPersistentPreferences.getToolchainId();
                int ix = ToolchainDefinition.findToolchainById((String)toolchainId);
                toolchains.add(ToolchainDefinition.getToolchain((int)ix));
            }
            catch (IndexOutOfBoundsException toolchainId) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainName = this.fPersistentPreferences.getToolchainName();
                int ix = ToolchainDefinition.findToolchainByName((String)toolchainName);
                toolchains.add(ToolchainDefinition.getToolchain((int)ix));
            }
            catch (IndexOutOfBoundsException toolchainName) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            int ix = ToolchainDefinition.getDefault();
            toolchains.add(ToolchainDefinition.getToolchain((int)ix));
        }
        for (ToolchainDefinition toolchain : toolchains) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchain.getFullName(), Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            boolean isStrict = this.fDefaultPreferences.getBoolean("workspace.toolchain.path.strict", true);
            String[] xpackNames = this.fDefaultPreferences.getToolchainXpackNames(toolchain.getId(), toolchain.getName());
            String key = PersistentPreferences.getToolchainKey((String)toolchain.getId(), (String)toolchain.getName());
            XpackDirectoryNotStrictFieldEditor toolchainPathField = new XpackDirectoryNotStrictFieldEditor(xpackNames, key, Messages.ToolchainPaths_label, this.getFieldEditorParent(), isStrict);
            this.addField((FieldEditor)toolchainPathField);
        }
        Label message = new Label(this.getFieldEditorParent(), 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        message.setLayoutData((Object)layoutData);
        message.setText(Messages.SetCrossCommandWizardPage_text);
    }
}

