/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.overlaps;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.radial.InternalProperties;
import org.eclipse.elk.alg.radial.RadialUtil;
import org.eclipse.elk.alg.radial.intermediate.compaction.AbstractRadiusExtensionCompaction;
import org.eclipse.elk.alg.radial.intermediate.overlaps.IOverlapRemoval;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.alg.radial.sorting.IRadialSorter;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class RadiusExtensionOverlapRemoval
extends AbstractRadiusExtensionCompaction
implements ILayoutProcessor<ElkNode>,
IOverlapRemoval {
    private IRadialSorter sorter;

    @Override
    public void removeOverlaps(ElkNode graph, IElkProgressMonitor progressMonitor) {
        ElkNode root = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
        this.setRoot(root);
        this.sorter = ((SortingStrategy)((Object)graph.getProperty(RadialOptions.SORTER))).create();
        Double spacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        this.setSpacing(spacing);
        List<ElkNode> successors = RadialUtil.getSuccessors(root);
        this.extend(graph, successors, progressMonitor);
    }

    public void extend(ElkNode graph, List<ElkNode> nodes, IElkProgressMonitor progressMonitor) {
        if (!nodes.isEmpty()) {
            ArrayList<KVector> oldPositions = new ArrayList<KVector>();
            for (ElkNode node : nodes) {
                oldPositions.add(new KVector(node.getX(), node.getY()));
            }
            progressMonitor.logGraph(graph, "Before removing overlaps");
            while (this.overlapLayer(nodes)) {
                this.contractLayer(nodes, false);
            }
            progressMonitor.logGraph(graph, "After removing overlaps");
            double movedX = 0.0;
            double movedY = 0.0;
            ElkNode firstNode = null;
            if (!nodes.isEmpty()) {
                firstNode = nodes.get(0);
                movedX = firstNode.getX() - ((KVector)oldPositions.get((int)0)).x;
                movedY = firstNode.getY() - ((KVector)oldPositions.get((int)0)).y;
            }
            double movedDistance = Math.sqrt(movedX * movedX + movedY * movedY);
            Set<ElkNode> nextLevelNodes = RadialUtil.getNextLevelNodeSet(nodes);
            int index = 1;
            if (!nextLevelNodes.isEmpty()) {
                for (ElkNode nextLevelNode : nextLevelNodes) {
                    this.moveNode(nextLevelNode, movedDistance);
                }
                progressMonitor.logGraph(graph, "Child movement " + index);
                ++index;
            }
            if (this.sorter != null) {
                this.sorter.sort(new ArrayList<ElkNode>(nextLevelNodes));
            }
            this.extend(graph, new ArrayList<ElkNode>(nextLevelNodes), progressMonitor);
        }
    }

    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Remove overlaps", 1.0f);
        progressMonitor.logGraph(graph, "Before");
        this.removeOverlaps(graph, progressMonitor);
        progressMonitor.logGraph(graph, "After");
    }
}

