/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.firstiteration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.firstiteration.AreaFilter;
import org.eclipse.elk.alg.rectpacking.firstiteration.AspectRatioFilter;
import org.eclipse.elk.alg.rectpacking.firstiteration.BestCandidateFilter;
import org.eclipse.elk.alg.rectpacking.firstiteration.Calculations;
import org.eclipse.elk.alg.rectpacking.firstiteration.ScaleMeasureFilter;
import org.eclipse.elk.alg.rectpacking.options.OptimizationGoal;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingDataDescriptor;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.graph.ElkNode;

public class AreaApproximation {
    private double aspectRatio;
    private OptimizationGoal goal;
    private boolean lpShift;

    public AreaApproximation(double aspectRatio, OptimizationGoal goal, boolean lpShift) {
        this.aspectRatio = aspectRatio;
        this.goal = goal;
        this.lpShift = lpShift;
    }

    public DrawingData approxBoundingBox(List<ElkNode> rectangles, double nodeNodeSpacing, ElkPadding padding) {
        ElkNode firstRect = rectangles.get(0);
        firstRect.setX(0.0);
        firstRect.setY(0.0);
        ArrayList<ElkNode> placedRects = new ArrayList<ElkNode>();
        placedRects.add(firstRect);
        ElkNode lastPlaced = firstRect;
        DrawingData currentValues = new DrawingData(this.aspectRatio, firstRect.getWidth(), firstRect.getHeight(), DrawingDataDescriptor.WHOLE_DRAWING);
        int rectangleIdx = 1;
        while (rectangleIdx < rectangles.size()) {
            ElkNode toPlace = rectangles.get(rectangleIdx);
            DrawingData opt1 = this.calcValuesForOpt(DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT, toPlace, lastPlaced, currentValues, placedRects, nodeNodeSpacing);
            DrawingData opt2 = this.calcValuesForOpt(DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW, toPlace, lastPlaced, currentValues, placedRects, nodeNodeSpacing);
            DrawingData opt3 = this.calcValuesForOpt(DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_RIGHT, toPlace, lastPlaced, currentValues, placedRects, nodeNodeSpacing);
            DrawingData opt4 = this.calcValuesForOpt(DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_BELOW, toPlace, lastPlaced, currentValues, placedRects, nodeNodeSpacing);
            DrawingData bestOpt = this.findBestCandidate(opt1, opt2, opt3, opt4, toPlace, lastPlaced, padding);
            toPlace.setX(bestOpt.getNextXcoordinate());
            toPlace.setY(bestOpt.getNextYcoordinate());
            bestOpt.setPlacementOption(DrawingDataDescriptor.WHOLE_DRAWING);
            currentValues = bestOpt;
            lastPlaced = toPlace;
            placedRects.add(toPlace);
            ++rectangleIdx;
        }
        return currentValues;
    }

    private DrawingData findBestCandidate(DrawingData opt1, DrawingData opt2, DrawingData opt3, DrawingData opt4, ElkNode toPlace, ElkNode lastPlaced, ElkPadding padding) {
        List<Object> candidates = Lists.newArrayList((Object[])new DrawingData[]{opt1, opt2, opt3, opt4});
        List filters = null;
        switch (this.goal) {
            case MAX_SCALE_DRIVEN: {
                filters = Lists.newArrayList((Object[])new BestCandidateFilter[]{new ScaleMeasureFilter(), new AreaFilter(), new AspectRatioFilter()});
                break;
            }
            case ASPECT_RATIO_DRIVEN: {
                filters = Lists.newArrayList((Object[])new BestCandidateFilter[]{new AspectRatioFilter(), new AreaFilter(), new ScaleMeasureFilter()});
                break;
            }
            case AREA_DRIVEN: {
                filters = Lists.newArrayList((Object[])new BestCandidateFilter[]{new AreaFilter(), new ScaleMeasureFilter(), new AspectRatioFilter()});
            }
        }
        for (BestCandidateFilter filter : filters) {
            if (candidates.size() <= 1) continue;
            candidates = filter.filterList(candidates, this.aspectRatio, padding);
        }
        if (candidates.size() == 1) {
            return (DrawingData)candidates.get(candidates.size() - 1);
        }
        if (candidates.size() == 2) {
            return this.checkSpecialCases((DrawingData)candidates.get(0), (DrawingData)candidates.get(1), lastPlaced, toPlace);
        }
        return null;
    }

    private DrawingData checkSpecialCases(DrawingData drawing1, DrawingData drawing2, ElkNode lastPlaced, ElkNode toPlace) {
        boolean secondOptLPRorLPB;
        DrawingDataDescriptor firstOpt = drawing1.getPlacementOption();
        DrawingDataDescriptor secondOpt = drawing2.getPlacementOption();
        boolean firstOptLPBorCDB = firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW || firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_BELOW;
        boolean secondOptLPBorCDB = secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW || secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_BELOW;
        boolean firstOptLPRorCDR = firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT || firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_RIGHT;
        boolean secondOptLPRorCDR = secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT || secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_RIGHT;
        boolean firstOptLPRorLPB = firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT || firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW;
        boolean bl = secondOptLPRorLPB = secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT || secondOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW;
        if (firstOptLPBorCDB && secondOptLPBorCDB) {
            if (drawing1.getPlacementOption() == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_BELOW) {
                return drawing1;
            }
            return drawing2;
        }
        if (firstOptLPRorCDR && secondOptLPRorCDR) {
            if (drawing1.getPlacementOption() == DrawingDataDescriptor.CANDIDATE_POSITION_WHOLE_DRAWING_RIGHT) {
                return drawing1;
            }
            return drawing2;
        }
        if (firstOptLPRorLPB && secondOptLPRorLPB) {
            DrawingData lpbOpt;
            DrawingData lprOpt;
            if (firstOpt == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT) {
                lprOpt = drawing1;
                lpbOpt = drawing2;
            } else {
                lprOpt = drawing2;
                lpbOpt = drawing1;
            }
            double areaLPR = Calculations.calculateAreaLPR(lastPlaced, toPlace, lprOpt);
            double areaLPB = Calculations.calculateAreaLPB(lastPlaced, toPlace, lpbOpt);
            if (areaLPR <= areaLPB) {
                if (drawing1.getPlacementOption() == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_RIGHT) {
                    return drawing1;
                }
                return drawing2;
            }
            if (drawing1.getPlacementOption() == DrawingDataDescriptor.CANDIDATE_POSITION_LAST_PLACED_BELOW) {
                return drawing1;
            }
            return drawing2;
        }
        return drawing1;
    }

    private DrawingData calcValuesForOpt(DrawingDataDescriptor option, ElkNode toPlace, ElkNode lastPlaced, DrawingData drawing, List<ElkNode> placedRects, double nodeNodeSpacing) {
        double height;
        double width;
        double x = 0.0;
        double y = 0.0;
        double drawingWidth = drawing.getDrawingWidth();
        double drawingHeight = drawing.getDrawingHeight();
        double heightToPlace = toPlace.getHeight();
        double widthToPlace = toPlace.getWidth();
        switch (option) {
            case CANDIDATE_POSITION_LAST_PLACED_RIGHT: {
                x = lastPlaced.getX() + lastPlaced.getWidth() + nodeNodeSpacing;
                y = this.lpShift ? Calculations.calculateYforLPR(x, placedRects, lastPlaced, nodeNodeSpacing) : lastPlaced.getY();
                width = Calculations.getWidthLPRorLPB(drawingWidth, x, widthToPlace);
                height = Calculations.getHeightLPRorLPB(drawingHeight, y, heightToPlace);
                break;
            }
            case CANDIDATE_POSITION_LAST_PLACED_BELOW: {
                y = lastPlaced.getY() + lastPlaced.getHeight() + nodeNodeSpacing;
                x = this.lpShift ? Calculations.calculateXforLPB(y, placedRects, lastPlaced, nodeNodeSpacing) : lastPlaced.getX();
                width = Calculations.getWidthLPRorLPB(drawingWidth, x, widthToPlace);
                height = Calculations.getHeightLPRorLPB(drawingHeight, y, heightToPlace);
                break;
            }
            case CANDIDATE_POSITION_WHOLE_DRAWING_RIGHT: {
                x = drawingWidth + nodeNodeSpacing;
                y = 0.0;
                width = drawingWidth + nodeNodeSpacing + widthToPlace;
                height = Math.max(drawingHeight, heightToPlace);
                break;
            }
            case CANDIDATE_POSITION_WHOLE_DRAWING_BELOW: {
                x = 0.0;
                y = drawingHeight + nodeNodeSpacing;
                width = Math.max(drawingWidth, widthToPlace);
                height = drawingHeight + nodeNodeSpacing + heightToPlace;
                break;
            }
            default: {
                throw new IllegalArgumentException("IllegalPlacementOption.");
            }
        }
        DrawingData newDrawing = new DrawingData(this.aspectRatio, width, height, option, x, y);
        return newDrawing;
    }
}

