/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;

public class LayoutAlgorithmResolver
implements IGraphElementVisitor {
    @Override
    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode && !((Boolean)element.getProperty(CoreOptions.NO_LAYOUT)).booleanValue()) {
            this.resolveAlgorithm((ElkNode)element);
        }
    }

    protected void resolveAlgorithm(ElkNode node) {
        String algorithmId = (String)node.getProperty(CoreOptions.ALGORITHM);
        LayoutAlgorithmData data = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffixOrDefault(algorithmId, this.getDefaultLayoutAlgorithmID());
        if (data != null) {
            node.setProperty(CoreOptions.RESOLVED_ALGORITHM, (Object)data);
        } else if (this.mustResolve(node)) {
            if (algorithmId == null || algorithmId.isEmpty()) {
                StringBuilder message = new StringBuilder("No layout algorithm has been specified for ");
                ElkUtil.printElementPath((ElkGraphElement)node, message);
                throw new UnsupportedConfigurationException(message.toString());
            }
            StringBuilder message = new StringBuilder("Layout algorithm '");
            message.append(algorithmId);
            message.append("' not found for ");
            ElkUtil.printElementPath((ElkGraphElement)node, message);
            throw new UnsupportedConfigurationException(message.toString());
        }
    }

    protected boolean mustResolve(ElkNode node) {
        return !node.hasProperty(CoreOptions.RESOLVED_ALGORITHM) && !node.getChildren().isEmpty();
    }

    public String getDefaultLayoutAlgorithmID() {
        return "org.eclipse.elk.layered";
    }
}

