/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.options;

import org.eclipse.elk.alg.spore.ShrinkTreeLayoutProvider;
import org.eclipse.elk.alg.spore.options.CompactionStrategy;
import org.eclipse.elk.alg.spore.options.RootSelection;
import org.eclipse.elk.alg.spore.options.SpanningTreeCostFunction;
import org.eclipse.elk.alg.spore.options.SporeMetaDataProvider;
import org.eclipse.elk.alg.spore.options.StructureExtractionStrategy;
import org.eclipse.elk.alg.spore.options.TreeConstructionStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class SporeCompactionOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.sporeCompaction";
    public static final IProperty<String> UNDERLYING_LAYOUT_ALGORITHM = SporeMetaDataProvider.UNDERLYING_LAYOUT_ALGORITHM;
    public static final IProperty<TreeConstructionStrategy> PROCESSING_ORDER_TREE_CONSTRUCTION = SporeMetaDataProvider.PROCESSING_ORDER_TREE_CONSTRUCTION;
    public static final IProperty<SpanningTreeCostFunction> PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION = SporeMetaDataProvider.PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION;
    public static final IProperty<String> PROCESSING_ORDER_PREFERRED_ROOT = SporeMetaDataProvider.PROCESSING_ORDER_PREFERRED_ROOT;
    public static final IProperty<RootSelection> PROCESSING_ORDER_ROOT_SELECTION = SporeMetaDataProvider.PROCESSING_ORDER_ROOT_SELECTION;
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(8.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 8.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)8.0);
    public static final IProperty<StructureExtractionStrategy> STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY = SporeMetaDataProvider.STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY;
    public static final IProperty<CompactionStrategy> COMPACTION_COMPACTION_STRATEGY = SporeMetaDataProvider.COMPACTION_COMPACTION_STRATEGY;
    public static final IProperty<Boolean> COMPACTION_ORTHOGONAL = SporeMetaDataProvider.COMPACTION_ORTHOGONAL;
    private static final boolean DEBUG_MODE_DEFAULT = false;
    public static final IProperty<Boolean> DEBUG_MODE = new Property(CoreOptions.DEBUG_MODE, (Object)false);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK SPOrE Compaction").description("ShrinkTree is a compaction algorithm that maintains the topology of a layout. The relocation of diagram elements is based on contracting a spanning tree.").providerFactory((IFactory)new SporeCompactionFactory()).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.spore").imagePath("images/compaction-example.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.underlyingLayoutAlgorithm", UNDERLYING_LAYOUT_ALGORITHM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.processingOrder.treeConstruction", PROCESSING_ORDER_TREE_CONSTRUCTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.processingOrder.spanningTreeCostFunction", PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.processingOrder.preferredRoot", PROCESSING_ORDER_PREFERRED_ROOT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.processingOrder.rootSelection", PROCESSING_ORDER_ROOT_SELECTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)8.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.structure.structureExtractionStrategy", STRUCTURE_STRUCTURE_EXTRACTION_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.compaction.compactionStrategy", COMPACTION_COMPACTION_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.compaction.orthogonal", COMPACTION_ORTHOGONAL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", (Object)false);
    }

    public static class SporeCompactionFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            ShrinkTreeLayoutProvider provider = new ShrinkTreeLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

