/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFValidator;
import org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.internal.dialogs.ActivityValidationSelectionDialog;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunActivityAction
implements IObjectActionDelegate {
    private Shell _shell;
    private IPlatformFcore _fcore;
    private Activity _activity;
    private List<Activity> _validates = null;

    public void run(IAction action) {
        EGFValidator validator;
        Diagnostic validationDiag;
        this._validates = null;
        if (this._fcore != null) {
            ActivitySelectionDialog activityDialog = new ActivitySelectionDialog(this._shell, this._fcore, false);
            activityDialog.setTitle(ProducerUIMessages.GlobalRunActivityAction_dialogTitle);
            int result = activityDialog.open();
            if (result != 0) {
                return;
            }
            Object[] selection = activityDialog.getResult();
            if (selection == null || selection.length != 1) {
                return;
            }
            this._activity = (Activity)selection[0];
        }
        if (this._activity == null) {
            return;
        }
        IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
        String validate = store.getString("org.eclipse.egf.core.validate.model.instances.before.launch");
        EList activities = this._activity.getActivities();
        int status = this.showValidateDialog((List<Activity>)activities, !validate.equals("never"), validate.equals("prompt"));
        if (status != 0) {
            return;
        }
        if (this._validates != null && this._validates.size() != 0 && (validationDiag = (validator = new EGFValidator(this._validates)).validate()).getSeverity() == 4) {
            return;
        }
        BasicEList tasks = new BasicEList();
        for (Activity activity : activities) {
            if (!(activity instanceof Task)) continue;
            tasks.add((Task)activity);
        }
        WorkspaceJob activityJob = new WorkspaceJob(ProducerUIMessages.GlobalRunActivityAction_label, (List)tasks){
            private final /* synthetic */ List val$tasks;
            {
                this.val$tasks = list;
                super($anonymous0);
            }

            public boolean belongsTo(Object family) {
                return EGFCorePlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectBundleSession session = new ProjectBundleSession(EGFProducerUIPlugin.getDefault().getBundle().getBundleContext());
                IActivityManager activityManager = null;
                SubMonitor subMonitor = null;
                UniqueEList fcores = new UniqueEList();
                for (Resource resource : RunActivityAction.this._activity.getResources()) {
                    IPlatformFcore fcore;
                    if (!(resource instanceof IPlatformFcoreProvider) || (fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore()).isRuntime() || fcore.getBundle() != null) continue;
                    if (fcore.isWorkspace()) {
                        fcores.add(fcore);
                        continue;
                    }
                    throw new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.TargetPlatform_ExtensionPoint_no_bundle, (Object)fcore.getPlatformBundle().getBundleId()), null));
                }
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)RunActivityAction.this._activity)), (int)(100 * fcores.size() + 1000 * this.val$tasks.size()));
                try {
                    for (IPlatformFcore fcore : fcores) {
                        SubMonitor childSubMonitor = subMonitor.newChild(100, 0);
                        childSubMonitor = SubMonitor.convert((IProgressMonitor)childSubMonitor, (String)NLS.bind((String)EGFCoreMessages.Production_Load_Bundle, (Object)fcore.getPlatformBundle().getBundleId()), (int)100);
                        session.getBundle(fcore.getPlatformBundle().getProject());
                    }
                    RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
                    Activity activity = (Activity)resourceSet.getEObject(EcoreUtil.getURI((EObject)RunActivityAction.this._activity), true);
                    ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity);
                    activityManager = producer.createActivityManager(activity);
                    activityManager.setProjectBundleSession(session);
                    activityManager.initializeContext();
                    final Diagnostic preInvokeDiag = activityManager.canInvoke();
                    if (preInvokeDiag.getSeverity() != 0) {
                        if (EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                            EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PreInvokeProblems_message, (Diagnostic)preInvokeDiag);
                                }
                            });
                        }
                        if (preInvokeDiag.getSeverity() == 4) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                    }
                    try {
                        if (EGFProducerUIPlugin.getDefault().isDebugging()) {
                            if (this.val$tasks.size() == 1) {
                                EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)activity)));
                            } else {
                                EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)activity), (Object)this.val$tasks.size()));
                            }
                        }
                        final Diagnostic diagnostic = activityManager.invoke((IProgressMonitor)subMonitor.newChild(1000 * this.val$tasks.size(), 0));
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (diagnostic != null && diagnostic.getSeverity() != 0 && EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                            EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PreInvokeProblems_message, (Diagnostic)diagnostic);
                                }
                            });
                        }
                    }
                    catch (InvocationException ie) {
                        if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                            throw (CoreException)ie.getCause();
                        }
                        ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                    }
                    catch (OperationCanceledException ex) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (Throwable t) {
                        throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                    }
                }
                finally {
                    monitor.done();
                    try {
                        if (activityManager != null) {
                            activityManager.dispose();
                        }
                    }
                    catch (Throwable t) {
                        EGFProducerUIPlugin.getDefault().logError(t);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        activityJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        activityJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)"elcl16/runactivity.gif");
        activityJob.setPriority(30);
        activityJob.setUser(true);
        activityJob.setSystem(false);
        activityJob.schedule();
    }

    protected Activity getActivitySelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selectedObject == null) {
            return null;
        }
        if (selectedObject instanceof Activity) {
            return (Activity)selectedObject;
        }
        return null;
    }

    protected IPlatformFcore getPlatformFcoreSelection(IStructuredSelection selection) {
        block5: {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject == null) {
                return null;
            }
            if (selectedObject instanceof IResource) {
                IPlatformFcore fcore;
                block6: {
                    TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
                    Resource resource = resourceSet.getResource(URIHelper.getPlatformPluginURI((IResource)((IResource)selectedObject)), true);
                    fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore();
                    if (fcore == null) break block5;
                    if (resource.getContents().size() != 1 || !(resource.getContents().get(0) instanceof Activity)) break block6;
                    this._activity = (Activity)resource.getContents().get(0);
                    return null;
                }
                try {
                    return fcore;
                }
                catch (Throwable t) {
                    EGFProducerUIPlugin.getDefault().logError(t);
                }
            }
        }
        return null;
    }

    private int showValidateDialog(List<Activity> activities, boolean validate, boolean prompt) {
        if (validate) {
            if (prompt && activities != null && activities.size() > 0) {
                ActivityValidationSelectionDialog dialog = new ActivityValidationSelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), activities);
                if (dialog.open() == 1) {
                    return 1;
                }
                Object[] objects = dialog.getResult();
                this._validates = new ArrayList<Activity>(objects.length);
                int i = 0;
                while (i < objects.length) {
                    this._validates.add((Activity)objects[i]);
                    ++i;
                }
            } else {
                this._validates = activities;
            }
        }
        return 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this._activity = null;
        if (selection instanceof IStructuredSelection) {
            this._activity = this.getActivitySelection((IStructuredSelection)selection);
            if (this._activity == null) {
                this._fcore = this.getPlatformFcoreSelection((IStructuredSelection)selection);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart activePart) {
        this._shell = activePart.getSite().getShell();
    }
}

