/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.model.ApprovalInfo;
import org.eclipse.egerrit.internal.model.LabelInfo;
import org.eclipse.emf.common.util.EMap;

public class Utils {
    private static final SimpleDateFormat formatTimeOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat sameYearFormatTimeOut = new SimpleDateFormat("MMM dd");
    private static final SimpleDateFormat sameDayFormatTimeOut = new SimpleDateFormat("HH:mm aa");
    private static final SimpleDateFormat differentYearFormatTimeOut = new SimpleDateFormat("MMM dd, yyyy");

    public static String formatDate(String inDate, SimpleDateFormat formatOut) {
        SimpleDateFormat formatIn = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
        Date dateNew = null;
        try {
            formatIn.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateNew = formatIn.parse(inDate);
        }
        catch (ParseException ex) {
            EGerritCorePlugin.logError(ex.getMessage());
        }
        return formatOut.format(dateNew).toString();
    }

    public static String prettyPrintDate(String inDate) {
        Date date = null;
        try {
            date = formatTimeOut.parse(inDate);
        }
        catch (ParseException e) {
            EGerritCorePlugin.logError(e.getMessage());
        }
        boolean sameDay = DateUtils.isSameDay((Date)date, (Date)Calendar.getInstance().getTime());
        Calendar today = Calendar.getInstance();
        Calendar currentReview = Calendar.getInstance();
        currentReview.setTime(date);
        if (sameDay) {
            return Utils.formatDate(inDate, sameDayFormatTimeOut);
        }
        if (today.get(1) != currentReview.get(1)) {
            return Utils.formatDate(inDate, differentYearFormatTimeOut);
        }
        return Utils.formatDate(inDate, sameYearFormatTimeOut);
    }

    public static Integer getStateValue(Integer newState, Integer oldState) {
        Integer state = 0;
        state = newState < 0 ? Integer.valueOf(Math.min(oldState, newState)) : (newState > 0 ? Integer.valueOf(Math.max(oldState, newState)) : oldState);
        return state;
    }

    public static int verifyTally(String testLabels, EMap<String, LabelInfo> labels) {
        int state = 0;
        if (labels != null && labels.get((Object)testLabels) != null) {
            for (Map.Entry entry : labels.entrySet()) {
                LabelInfo labelInfo;
                if (entry.getKey() == null || ((String)entry.getKey()).compareTo(testLabels) != 0 || (labelInfo = (LabelInfo)entry.getValue()).getAll() == null) continue;
                for (ApprovalInfo it : labelInfo.getAll()) {
                    if (it.getValue() == null) continue;
                    state = Utils.getStateValue(it.getValue(), state);
                }
            }
        }
        return state;
    }
}

