/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.fx.ide.model.Util;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;

public class FxmlAnnotationCompilationParticipant
extends CompilationParticipant {
    private static final String MARKER = "org.eclipse.jdt.core.problem";

    public boolean isActive(IJavaProject project) {
        return true;
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        BuildContext[] buildContextArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                BuildContext context = buildContextArray[n2];
                List<CategorizedProblem> problems = null;
                try {
                    try {
                        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)context.getFile());
                        problems = FxmlAnnotationCompilationParticipant.checkCU(unit, null);
                        context.recordNewProblems(problems.toArray(new CategorizedProblem[problems.size()]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (problems != null) {
                            problems.clear();
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (problems != null) {
                        problems.clear();
                    }
                    throw throwable;
                }
                if (problems != null) {
                    problems.clear();
                }
            }
            ++n2;
        }
    }

    public void reconcile(ReconcileContext context) {
        super.reconcile(context);
        List<CategorizedProblem> problems = null;
        try {
            try {
                List<CategorizedProblem> existingProblems = null;
                if (context.getProblems(MARKER) != null) {
                    existingProblems = Arrays.asList(context.getProblems(MARKER));
                }
                problems = FxmlAnnotationCompilationParticipant.checkCU(context.getWorkingCopy(), existingProblems);
                context.putProblems(MARKER, problems.toArray(new CategorizedProblem[problems.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (problems != null) {
                    problems.clear();
                }
            }
        }
        finally {
            if (problems != null) {
                problems.clear();
            }
        }
    }

    private static List<CategorizedProblem> checkCU(ICompilationUnit unit, Collection<CategorizedProblem> existingProblems) {
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        if (existingProblems != null) {
            problems.addAll(existingProblems);
        }
        ArrayList<String> fxmlMethods = new ArrayList<String>();
        try {
            IJavaProject project = unit.getJavaProject();
            IType[] iTypeArray = unit.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                IMethod[] iMethodArray = type.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    IAnnotation[] iAnnotationArray = method.getAnnotations();
                    int n5 = iAnnotationArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation a = iAnnotationArray[n6];
                        if ("FXML".equals(a.getElementName())) {
                            DefaultProblem problem;
                            if (fxmlMethods.contains(method.getElementName())) {
                                problem = new DefaultProblem(unit.getElementName().toCharArray(), "JavaFX controller method name is not unique: " + method.getElementName(), 900, new String[0], 0, method.getSourceRange().getOffset(), method.getSourceRange().getOffset() + method.getSourceRange().getLength(), FxmlAnnotationCompilationParticipant.getMethodLineNumber(type, method), 0);
                                problems.add((CategorizedProblem)problem);
                            }
                            fxmlMethods.add(method.getElementName());
                            switch (method.getNumberOfParameters()) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    ILocalVariable pType = method.getParameters()[0];
                                    String[][] resolvedType = type.resolveType(Signature.toString((String)pType.getTypeSignature()));
                                    IType parameterType = null;
                                    if (resolvedType != null) {
                                        parameterType = project.findType(String.valueOf(resolvedType[0][0]) + "." + resolvedType[0][1]);
                                    }
                                    if (resolvedType != null && Util.assignable(parameterType, (IType)project.findType("javafx.event.Event"))) break;
                                    DefaultProblem problem2 = new DefaultProblem(unit.getElementName().toCharArray(), "Parameter '" + pType.getElementName() + "' is not assignable to javafx.event.Event", 900, new String[0], 0, pType.getSourceRange().getOffset(), pType.getSourceRange().getOffset() + pType.getSourceRange().getLength(), FxmlAnnotationCompilationParticipant.getMethodLineNumber(type, method), 0);
                                    problems.add((CategorizedProblem)problem2);
                                    break;
                                }
                                default: {
                                    problem = new DefaultProblem(unit.getElementName().toCharArray(), "JavaFX controller method must have 0 or exactly 1 argument", 900, new String[0], 0, method.getSourceRange().getOffset(), method.getSourceRange().getOffset() + method.getSourceRange().getLength(), FxmlAnnotationCompilationParticipant.getMethodLineNumber(type, method), 0);
                                    problems.add((CategorizedProblem)problem);
                                }
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return problems;
    }

    private static int getMethodLineNumber(IType type, IMethod method) throws JavaModelException {
        String source = type.getCompilationUnit().getSource();
        String sourceUpToMethod = source.substring(0, method.getSourceRange().getOffset());
        Pattern lineEnd = Pattern.compile("$", 40);
        return lineEnd.split(sourceUpToMethod).length;
    }
}

