/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.list;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import org.eclipse.fx.ui.controls.styledtext.StyledLabel;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleListCell<T>
extends ListCell<T> {
    private final @NonNull Function<@Nullable T, @Nullable CharSequence> labelExtractor;
    private final @NonNull Function<@Nullable T, @Nullable Node> graphicExtractor;
    private final @NonNull Function<@Nullable T, @NonNull List<@NonNull String>> cssClassProvider;

    public SimpleListCell(@NonNull Function<@Nullable T, @Nullable CharSequence> labelExtractor) {
        this(labelExtractor, i -> Collections.emptyList());
    }

    public SimpleListCell(@NonNull Function<@Nullable T, @Nullable CharSequence> labelExtractor, @NonNull Function<@Nullable T, @NonNull List<@NonNull String>> cssClassProvider) {
        this(labelExtractor, i -> null, cssClassProvider);
    }

    public SimpleListCell(@NonNull Function<@Nullable T, @Nullable CharSequence> labelExtractor, @NonNull Function<@Nullable T, @Nullable Node> graphicExtractor, @NonNull Function<@Nullable T, @NonNull List<@NonNull String>> cssClassProvider) {
        this.labelExtractor = labelExtractor;
        this.graphicExtractor = graphicExtractor;
        this.cssClassProvider = cssClassProvider;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!empty && item != null) {
            CharSequence t = this.labelExtractor.apply(item);
            if (t instanceof StyledString) {
                this.setText("");
                StyledLabel l = new StyledLabel((StyledString)t);
                l.getStyleClass().addAll((Collection)this.cssClassProvider.apply(item));
                Node g = this.graphicExtractor.apply(item);
                if (g != null) {
                    l.setGraphic(g);
                }
                this.setGraphic((Node)l);
            } else {
                Node g = this.graphicExtractor.apply(item);
                List<String> apply = this.cssClassProvider.apply(item);
                if (!apply.isEmpty()) {
                    Label l = new Label(t == null ? "" : t.toString());
                    l.getStyleClass().addAll(apply);
                    l.setGraphic(g);
                    this.setGraphic((Node)l);
                    this.setText("");
                } else {
                    this.setText(t == null ? "" : t.toString());
                    this.setGraphic(g);
                }
            }
        } else {
            this.setText("");
            this.setGraphic(null);
        }
    }
}

