/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.parser;

import java.util.Collections;
import java.util.List;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.WSTok;
import org.eclipse.fx.ide.css.cssext.parser.ParserInput;
import org.eclipse.fx.ide.css.util.TokUtil;

public class ParserInputCursor {
    private final ParserInput input;
    private int position;

    ParserInputCursor(ParserInput input) {
        this(input, 0);
    }

    ParserInputCursor(ParserInput input, int position) {
        this.input = input;
        this.position = position;
    }

    public boolean isConsumed() {
        return this.position > this.input.input.size() - 1;
    }

    public boolean isConsumedOrOnlyWSLeft() {
        if (this.isConsumed()) {
            return true;
        }
        if (this.input.input.size() == 0) {
            return true;
        }
        boolean isWS = true;
        int i = this.position;
        while (i < this.input.input.size()) {
            if (!(this.input.input.get(i) instanceof WSTok)) {
                isWS = false;
                break;
            }
            ++i;
        }
        return isWS;
    }

    public CssTok pollNextToken() {
        if (this.position >= this.input.input.size()) {
            return null;
        }
        return this.input.input.get(this.position++);
    }

    public CssTok peekNextToken() {
        if (this.position >= this.input.input.size()) {
            return null;
        }
        return this.input.input.get(this.position);
    }

    public ParserInputCursor copy() {
        return new ParserInputCursor(this.input, this.position);
    }

    public String toString() {
        if (this.isConsumed()) {
            return "{}";
        }
        StringBuffer out = new StringBuffer();
        out.append("{");
        int x = this.position;
        while (x < this.input.input.size()) {
            CssTok tok = this.input.input.get(x);
            out.append(TokUtil.toString((CssTok)tok));
            if (x < this.input.input.size() - 1) {
                out.append(", ");
            }
            ++x;
        }
        out.append("}");
        return out.toString();
    }

    public int getPosition() {
        return this.position;
    }

    public static ParserInputCursor emptyParserInputCursor() {
        List<CssTok> input = Collections.emptyList();
        return new ParserInputCursor(new ParserInput(input), 0);
    }
}

