/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.css.cssDsl.CssDslPackage;
import org.eclipse.fx.ide.css.cssDsl.css_declaration;
import org.eclipse.fx.ide.css.cssDsl.css_property;
import org.eclipse.fx.ide.css.cssDsl.ruleset;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.extapi.CssExt;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.fx.ide.css.util.Utils;
import org.eclipse.fx.ide.css.validation.AbstractCssDslJavaValidator;
import org.eclipse.xtext.validation.Check;

public class CssDslJavaValidator
extends AbstractCssDslJavaValidator {
    @Inject
    private CssExt ext;

    @Check
    public void checkProperty(css_property property) {
    }

    @Check
    public void checkDeclaration(css_declaration dec) {
        css_property property = dec.getProperty();
        dec.getValueTokens();
        dec.eResource().getURI();
        List<Proposal> properties = this.ext.getPropertyProposalsForSelector(Utils.getFile(dec.eResource()), dec, null);
        boolean known = false;
        for (Proposal p : properties) {
            if (!p.getProposal().equals(property.getName())) continue;
            known = true;
            break;
        }
        if (!known) {
            this.warning("Unknown property: \"" + property.getName() + "\"", (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__PROPERTY);
        } else {
            ruleset rs = (ruleset)dec.eContainer();
            EList<selector> selectors = rs.getSelectors();
            List<Proposal> selectorProps = this.ext.getPropertyProposalsForSelector(Utils.getFile(dec.eResource()), dec, (List<selector>)selectors);
            if (selectorProps.size() > 0) {
                boolean supported = false;
                for (Proposal p : selectorProps) {
                    if (!p.getProposal().equals(property.getName())) continue;
                    supported = true;
                    break;
                }
                if (!supported) {
                    this.warning("\"" + property.getName() + "\" is not supported by the given selectors", (EStructuralFeature)CssDslPackage.Literals.CSS_DECLARATION__PROPERTY);
                }
            }
        }
    }
}

