/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.Optional;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.CustomContainerSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.SortedBorderPane;
import org.eclipse.fx.ui.workbench.renderers.fx.services.LightweightDialogTransitionService;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefPartRenderer
extends BasePartRenderer<Pane, Node, Node> {
    protected Class<? extends WPart<Pane, Node, Node>> getWidgetClass(MPart part) {
        return PartImpl.class;
    }

    protected boolean requiresFocus(WPart<Pane, Node, Node> widget) {
        return true;
    }

    public void focus(MUIElement element) {
        super.focus(element);
        if (element.getWidget() instanceof WPart) {
            WPart part = (WPart)element.getWidget();
            if (part == null) {
                return;
            }
            if (!DefPartRenderer.checkFocusControl((Node)part.getStaticLayoutNode())) {
                Node node = (Node)part.getWidget();
                if (node instanceof Parent) {
                    DefPartRenderer.getFirstFocusableNode((Parent)node).ifPresent(Node::requestFocus);
                } else {
                    node.requestFocus();
                }
            }
        }
    }

    static Optional<Node> getFirstFocusableNode(Parent parent) {
        if (parent.isVisible()) {
            for (Node node : parent.getChildrenUnmodifiable()) {
                Optional<Node> opt;
                if (node instanceof Parent && (opt = DefPartRenderer.getFirstFocusableNode((Parent)node)).isPresent()) {
                    return opt;
                }
                if (!node.isFocusTraversable() || !node.isVisible()) continue;
                return Optional.of(node);
            }
        }
        return Optional.empty();
    }

    /*
     * Unable to fully structure code
     */
    static boolean checkFocusControl(Node check) {
        if (check.getScene() == null) {
            return false;
        }
        n = check.getScene().getFocusOwner();
        if (n != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (n.getParent() == check) {
                return true;
            }
            n = n.getParent();
lbl9:
            // 2 sources

            ** while (n.getParent() != null)
        }
lbl10:
        // 1 sources

        return false;
    }

    static class HandleGroup
    extends Group {
        public double minHeight(double width) {
            return 11.0;
        }

        public double maxWidth(double height) {
            return 20.0;
        }

        public HandleGroup() {
            Rectangle r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(1.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(4.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
            r = new Rectangle(16.0, 1.0);
            r.setFill((Paint)Color.WHITE);
            r.setStroke((Paint)Color.BLACK);
            r.setLayoutX(0.0);
            r.setLayoutY(7.0);
            r.setStrokeType(StrokeType.OUTSIDE);
            this.getChildren().add((Object)r);
        }
    }

    public static class PartImpl
    extends WLayoutedWidgetImpl<Pane, AnchorPane, MPart>
    implements WPart<Pane, Node, Node> {
        @Inject
        @NonNull IEclipseContext context;
        @Inject
        private GraphicsLoader graphicsLoader;
        AnchorPane contentArea;
        private BorderPane dataArea;
        private StackPane expandGroup;
        StackPane toolbarGroup;
        Group menuGroup;
        private WMenu<Node> viewMenuWidget;
        private WToolBar<Node> viewToolbarWidget;
        private StackPane overlayContainer;
        private Label titleLabel;
        private MPart domElement;
        @Inject
        @org.eclipse.e4.core.di.annotations.Optional
        LightweightDialogTransitionService dialogTransitionService;
        private TitledPane titledPane;

        @Inject
        public PartImpl(@Named(value="fx.rendering.domElement") @Named(value="fx.rendering.domElement") @NonNull MPart domElement) {
            this.domElement = domElement;
        }

        @Override
        protected Pane createWidget() {
            Pane tmp = CustomContainerSupport.createContainerPane(this.logger, this.context);
            final Object p = tmp == null ? new SortedBorderPane() : tmp;
            p.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    MPart domElement = (MPart)this.getDomElement();
                    if (domElement != null) {
                        ((EPartService)domElement.getContext().get(EPartService.class)).activate(domElement, true);
                        if (!DefPartRenderer.checkFocusControl(this.getStaticLayoutNode()) && domElement.getObject() != null) {
                            p.requestFocus();
                        }
                    }
                }
            });
            return p;
        }

        @Override
        public AnchorPane getWidgetNode() {
            if (this.contentArea == null) {
                this.menuGroup = new Group();
                this.menuGroup.setVisible(false);
                this.menuGroup.setManaged(false);
                this.expandGroup = new StackPane();
                this.expandGroup.getStyleClass().add((Object)"part-expand-group");
                this.expandGroup.setOpacity(0.5);
                HandleGroup handler = new HandleGroup();
                handler.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        toolbarGroup.getParent().setVisible(true);
                    }
                });
                this.expandGroup.getChildren().add((Object)handler);
                this.contentArea = new AnchorPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (menuGroup.isVisible()) {
                            menuGroup.relocate(contentArea.getWidth() - 20.0, 0.0);
                        }
                    }
                };
                this.dataArea = new SortedBorderPane();
                if (this.domElement != null && this.domElement.getTags().contains("showTopTrimArea")) {
                    HBox box = new HBox();
                    box.getStyleClass().add((Object)"tool-bar");
                    this.titleLabel = new Label();
                    box.getChildren().add((Object)this.titleLabel);
                    this.dataArea.setTop((Node)box);
                }
                AnchorPane.setTopAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)this.dataArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)this.dataArea, (Double)0.0);
                this.contentArea.getChildren().addAll((Object[])new Node[]{this.dataArea, this.menuGroup});
                Node n = (Node)this.getWidget();
                n.getStyleClass().add((Object)"part-content");
                if (this.domElement.getTags().contains("fx_scrollable")) {
                    ScrollPane scroll = new ScrollPane(n);
                    scroll.setFitToHeight(true);
                    scroll.setFitToWidth(true);
                    n = scroll;
                }
                if (this.domElement.getTags().contains("fx_withCollapsibleContent")) {
                    SortedBorderPane content = new SortedBorderPane();
                    content.setCenter(n);
                    content.setStyle("-fx-padding: 0px;");
                    this.titledPane = new TitledPane("", (Node)content);
                    this.titledPane.expandedProperty().addListener((ob, ol, ne) -> {
                        this.domElement.getPersistedState().put("efxCollapsed", String.valueOf(ne == false));
                        this.domElement.getPersistedState().put("efxSashFixed", String.valueOf(ne == false));
                    });
                    if (Boolean.parseBoolean(this.domElement.getPersistedState().getOrDefault("efxCollapsed", "false"))) {
                        this.titledPane.setExpanded(false);
                        this.domElement.getPersistedState().put("efxSashFixed", "true");
                    }
                    this.titledPane.getStyleClass().add((Object)"efx-expandable-title-pane");
                    this.titledPane.setMaxHeight(Double.MAX_VALUE);
                    n = this.titledPane;
                }
                this.dataArea.setCenter(n);
            }
            return this.contentArea;
        }

        private void initToolbarMenu() {
            if (this.toolbarGroup == null) {
                this.getStaticLayoutNode();
                if (this.titledPane != null) {
                    this.toolbarGroup = new StackPane();
                    ((BorderPane)this.titledPane.getContent()).setTop((Node)this.toolbarGroup);
                } else {
                    this.toolbarGroup = new StackPane();
                    MPart element = (MPart)this.getDomElement();
                    if (element != null && element.getTags().contains("Part-Toolbar-FullSpan")) {
                        final BorderPane p = new BorderPane();
                        p.setCenter((Node)this.toolbarGroup);
                        p.getStyleClass().add((Object)"view-toolbar-container");
                        if (element.getTags().contains("Part-ToolBarMenu-Floating")) {
                            AnchorPane.setLeftAnchor((Node)p, (Double)0.0);
                            AnchorPane.setRightAnchor((Node)p, (Double)0.0);
                            AnchorPane.setTopAnchor((Node)p, (Double)0.0);
                            this.contentArea.getChildren().add((Object)p);
                            p.setVisible(false);
                            this.dataArea.setTop((Node)this.expandGroup);
                            this.expandGroup.setVisible(true);
                            p.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    p.setVisible(false);
                                }
                            });
                        } else if (element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                            this.dataArea.setBottom((Node)p);
                        } else {
                            this.dataArea.setTop((Node)p);
                        }
                    } else {
                        BorderPane p = new BorderPane();
                        p.setRight((Node)this.toolbarGroup);
                        p.getStyleClass().add((Object)"view-toolbar-container");
                        if (element != null && element.getTags().contains("Part-ToolBarMenu-Bottom")) {
                            this.dataArea.setBottom((Node)p);
                        } else {
                            this.dataArea.setTop((Node)p);
                        }
                    }
                }
            }
        }

        public void setToolbar(WToolBar<Node> widget) {
            if (widget == null) {
                if (this.toolbarGroup != null) {
                    this.toolbarGroup.getChildren().clear();
                    this.dataArea.setTop(null);
                    this.dataArea.setBottom(null);
                    this.toolbarGroup = null;
                }
            } else {
                this.initToolbarMenu();
                Node n = (Node)widget.getWidget();
                n.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        MPart element = (MPart)this.getDomElement();
                        if (element != null && element.getTags().contains("Part-ToolBarMenu-Floating")) {
                            toolbarGroup.getParent().setVisible(false);
                        }
                    }
                });
                n.getStyleClass().add((Object)"view-toolbar");
                this.toolbarGroup.getChildren().setAll((Object[])new Node[]{n});
            }
            this.viewToolbarWidget = widget;
        }

        public void setMenu(WMenu<Node> widget) {
            if (widget == null) {
                if (this.menuGroup != null) {
                    this.menuGroup.setVisible(false);
                    this.menuGroup.getChildren().clear();
                }
            } else {
                this.menuGroup.setVisible(true);
                this.menuGroup.getChildren().setAll((Object[])new Node[]{(Node)widget.getWidget()});
                this.contentArea.requestLayout();
            }
            this.viewMenuWidget = widget;
        }

        public WMenu<Node> getMenu() {
            return this.viewMenuWidget;
        }

        public @Nullable WToolBar<Node> getToolbar() {
            return this.viewToolbarWidget;
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") @Named(value="localizedLabel") String label) {
            this.getWidget();
            if (this.titleLabel != null) {
                this.titleLabel.setText(label);
            }
            if (this.titledPane != null) {
                this.titledPane.setText(label);
            }
        }

        @Inject
        public void setGraphic(@Named(value="iconURI") @Named(value="iconURI") String iconURI) {
            this.getWidget();
            if (this.titleLabel != null) {
                if (iconURI != null) {
                    this.titleLabel.setGraphic(this.graphicsLoader.getGraphicsNode(URI.create((String)iconURI)));
                } else {
                    this.titleLabel.setGraphic(null);
                }
            }
            if (this.titledPane != null) {
                if (iconURI != null) {
                    this.titledPane.setGraphic(this.graphicsLoader.getGraphicsNode(URI.create((String)iconURI)));
                } else {
                    this.titledPane.setGraphic(null);
                }
            }
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    if (this.dialogTransitionService != null) {
                        this.dialogTransitionService.hideDialog((MUIElement)this.domElement, staticLayoutNode, (Pane)this.overlayContainer, (Node)this.overlayContainer, this.overlayContainer.getChildren().size() == 1 ? (Node)this.overlayContainer.getChildren().get(0) : null, () -> {
                            staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                            this.overlayContainer.getChildren().clear();
                        });
                    } else {
                        staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                        this.overlayContainer.getChildren().clear();
                    }
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane(){

                        protected void layoutChildren() {
                            Insets insets = this.getInsets();
                            double w = this.getWidth() - insets.getLeft() - insets.getRight();
                            double h = this.getHeight() - insets.getTop() - insets.getBottom();
                            for (Node n : this.getManagedChildren()) {
                                double y;
                                double x;
                                n.autosize();
                                if (n instanceof Region) {
                                    x = w / 2.0 - Math.min(w, ((Region)n).getWidth()) / 2.0;
                                    y = h / 2.0 - Math.min(h, ((Region)n).getHeight()) / 2.0;
                                } else {
                                    x = w / 2.0 - Math.min(w, n.prefWidth(-1.0)) / 2.0;
                                    y = h / 2.0 - Math.min(h, n.prefHeight(-1.0)) / 2.0;
                                }
                                n.relocate(x, y);
                            }
                        }
                    };
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                this.overlayContainer.layout();
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
                if (this.dialogTransitionService != null) {
                    this.dialogTransitionService.showDialog((MUIElement)this.domElement, staticLayoutNode, (Pane)this.overlayContainer, (Node)this.overlayContainer, (Node)dialogNode, null);
                }
            }
        }
    }
}

