/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.registration;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.eclipse.equinox.http.servlet.dto.ExtendedServletDTO;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupport;
import org.eclipse.equinox.http.servlet.internal.multipart.MultipartSupportFactory;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.MatchableRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;

public class ServletRegistration
extends EndpointRegistration<ExtendedServletDTO> {
    private static MultipartSupportFactory factory;
    private final boolean needDecode;
    private final ErrorPageDTO errorPageDTO;
    private final MultipartSupport multipartSupport;

    static {
        ServiceLoader<MultipartSupportFactory> loader = ServiceLoader.load(MultipartSupportFactory.class);
        Iterator<MultipartSupportFactory> iterator = loader.iterator();
        while (iterator.hasNext()) {
            try {
                factory = iterator.next();
                break;
            }
            catch (Throwable throwable) {}
        }
    }

    public ServletRegistration(ContextController.ServiceHolder<Servlet> servletHolder, ExtendedServletDTO servletDTO, ErrorPageDTO errorPageDTO, ServletContextHelper servletContextHelper, ContextController contextController, ServletContext servletContext, ClassLoader legacyTCCL) {
        super(servletHolder, servletDTO, servletContextHelper, contextController, legacyTCCL);
        this.errorPageDTO = errorPageDTO;
        if (servletDTO.multipartEnabled) {
            if (factory == null) {
                throw new IllegalStateException("Multipart support not enabled due to missing, optional commons-fileupload dependency!");
            }
            this.multipartSupport = factory.newInstance(servletDTO, servletContext);
        } else {
            this.multipartSupport = null;
        }
        this.needDecode = MatchableRegistration.patternsRequireDecode(servletDTO.patterns);
    }

    public ErrorPageDTO getErrorPageDTO() {
        return this.errorPageDTO;
    }

    @Override
    public String getName() {
        return ((ExtendedServletDTO)((Object)this.getD())).name;
    }

    @Override
    public String[] getPatterns() {
        return ((ExtendedServletDTO)((Object)this.getD())).patterns;
    }

    @Override
    public long getServiceId() {
        return ((ExtendedServletDTO)((Object)this.getD())).serviceId;
    }

    @Override
    public String match(String name, String servletPath, String pathInfo, String extension, Match match) {
        if (this.errorPageDTO != null && name != null) {
            long[] lArray = this.errorPageDTO.errorCodes;
            int n = this.errorPageDTO.errorCodes.length;
            int n2 = 0;
            while (n2 < n) {
                long errorCode = lArray[n2];
                if (String.valueOf(errorCode).equals(name)) {
                    return name;
                }
                ++n2;
            }
            String[] stringArray = this.errorPageDTO.exceptions;
            n2 = this.errorPageDTO.exceptions.length;
            int n3 = 0;
            while (n3 < n2) {
                String exception = stringArray[n3];
                if (exception.equals(name)) {
                    return name;
                }
                ++n3;
            }
        }
        return super.match(name, servletPath, pathInfo, extension, match);
    }

    public Map<String, Part> parseRequest(HttpServletRequest request) throws IOException, ServletException {
        if (this.multipartSupport == null) {
            throw new IOException("Servlet not configured for multipart!");
        }
        return this.multipartSupport.parseRequest(request);
    }

    @Override
    public boolean needDecode() {
        return this.needDecode;
    }
}

