/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.samples;

import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import org.eclipse.fx.drift.DriftFXSurface;
import org.eclipse.fx.drift.samples.ARenderer;
import org.eclipse.fx.drift.samples.SimpleColorRenderer;
import org.eclipse.fx.drift.samples.SimpleTriangleRenderer;

public class Demo
extends Application {
    Node create() {
        DriftFXSurface surface0 = new DriftFXSurface();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)surface0.widthProperty());
        clip.heightProperty().bind((ObservableValue)surface0.heightProperty());
        surface0.setClip((Node)clip);
        BorderPane dummy = new BorderPane();
        dummy.setStyle("-fx-padding: 20");
        dummy.setCenter((Node)surface0);
        ComboBox renderers = new ComboBox();
        renderers.setButtonCell((ListCell)new CellImpl());
        renderers.setCellFactory(v -> new CellImpl());
        renderers.getItems().add((Object)new SimpleColorRenderer(surface0));
        renderers.getItems().add((Object)new SimpleTriangleRenderer(surface0));
        Button stop = new Button("Stop");
        stop.setMinWidth(Double.NEGATIVE_INFINITY);
        Button start = new Button("Start");
        start.setMinWidth(Double.NEGATIVE_INFINITY);
        stop.setOnAction(a -> {
            ((ARenderer)renderers.getSelectionModel().getSelectedItem()).stop();
            start.setDisable(false);
            stop.setDisable(true);
            renderers.setDisable(false);
        });
        start.setOnAction(a -> {
            if (renderers.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            renderers.setDisable(true);
            start.setDisable(true);
            stop.setDisable(false);
            ((ARenderer)renderers.getSelectionModel().getSelectedItem()).start();
        });
        stop.setDisable(true);
        dummy.setBottom((Node)new HBox(new Node[]{renderers, start, stop}));
        return dummy;
    }

    public void start(Stage primaryStage) throws Exception {
        DriftFXSurface.initialize();
        BorderPane root = new BorderPane();
        root.setPrefSize(400.0, 300.0);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        Node a = this.create();
        Node b = this.create();
        HBox hbox = new HBox();
        hbox.getChildren().setAll((Object[])new Node[]{a, b});
        HBox.setHgrow((Node)a, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)b, (Priority)Priority.ALWAYS);
        root.setCenter((Node)hbox);
        primaryStage.show();
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }

    static class CellImpl
    extends ListCell<ARenderer> {
        CellImpl() {
        }

        protected void updateItem(ARenderer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
            } else {
                this.setText(item.getClass().getSimpleName());
            }
        }
    }
}

