/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicEAnnotationValidator
implements EAnnotationValidator {
    public static final int INVALID_LOCATION = 1;
    public static final int INVALID_DUPLICATE = 2;
    public static final int INVALID_REFERENCE_LITERAL = 3;
    public static final int INVALID_DETAIL_VALUE = 4;
    public static final int INVALID_VALUE_LITERAL = 5;
    public static final int IGNORED_ANNOTATIONS = 6;
    public static final int IGNORED_CONTENTS = 7;
    public static final int IGNORED_REFERENCES = 8;
    public static final int INVALID_REFERENCE = 9;
    public static final int INVALID_ANNOTATION = 10;
    public static final int INVALID_CONTENT = 11;
    public static final int IGNORED_ENTRY = 12;
    public static final int MISSING_ENTRY = 13;
    public static final int MISSING_REQUIRED_ENTRY_VALUE = 14;
    public static final int TOO_FEW_VALUES = 15;
    public static final int TOO_MANY_VALUES = 16;
    protected final String annotationSource;
    protected final String annotationName;
    protected final String diagnosticSource;
    protected final Assistant assistant;

    public BasicEAnnotationValidator(String annotationSource, String annotationName, String diagnosticSource) {
        this.annotationSource = annotationSource;
        this.annotationName = annotationName;
        this.diagnosticSource = diagnosticSource;
        this.assistant = this.createAssistant();
    }

    @Override
    public String getAnnotationSource() {
        return this.annotationSource;
    }

    protected abstract ResourceLocator getResourceLocator();

    protected abstract List<EClass> getPropertyClasses(EModelElement var1);

    public Assistant getAssistant() {
        return this.assistant;
    }

    protected Assistant createAssistant() {
        return new Assistant(this){};
    }

    @Override
    public boolean isValidLocation(EAnnotation eAnnotation) {
        EModelElement eModelElement = eAnnotation.getEModelElement();
        if (eModelElement == null || !this.isValidLocation(eAnnotation, eModelElement)) {
            return false;
        }
        EAnnotation otherEAnnotation = eModelElement.getEAnnotation(this.annotationSource);
        return otherEAnnotation == null || otherEAnnotation == eAnnotation || this.isDuplicateValid(eModelElement, otherEAnnotation, eAnnotation);
    }

    protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
        return eModelElement instanceof ENamedElement;
    }

    protected boolean isDuplicateValid(EModelElement eModelElement, EAnnotation primaryEAnnotation, EAnnotation secondaryEAnnotation) {
        return false;
    }

    @Override
    public boolean validate(EAnnotation eAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        EModelElement eModelElement = eAnnotation.getEModelElement();
        if (eModelElement != null && this.isValidLocation(eAnnotation, eModelElement)) {
            EAnnotation otherEAnnotation = eModelElement.getEAnnotation(this.annotationSource);
            if (otherEAnnotation == eAnnotation || this.isDuplicateValid(eModelElement, otherEAnnotation, eAnnotation)) {
                result = this.validateReferences(eAnnotation, eModelElement, diagnostics, context);
                if (result || diagnostics != null) {
                    result &= this.validateContents(eAnnotation, eModelElement, diagnostics, context);
                }
                if (result || diagnostics != null) {
                    result &= this.validateAnnotations(eAnnotation, eModelElement, diagnostics, context);
                }
                if (result || diagnostics != null) {
                    result &= this.validateDetails(eAnnotation, eModelElement, diagnostics, context);
                }
            } else {
                result = false;
                if (diagnostics != null) {
                    this.reportDuplicate(otherEAnnotation, eAnnotation, eModelElement, diagnostics, context);
                }
            }
        } else {
            result = false;
            if (diagnostics != null) {
                this.reportInvalidLocation(eAnnotation, diagnostics, context);
            }
        }
        return result;
    }

    protected boolean validateReferences(EAnnotation eAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<EObject> references = eAnnotation.getReferences();
        if (!this.isReferencesSupported(eAnnotation, eModelElement)) {
            boolean result = references.isEmpty();
            if (!result && diagnostics != null) {
                this.reportIgnoredReferences(eAnnotation, eModelElement, (Collection<? extends EObject>)references, diagnostics, context);
            }
            return result;
        }
        boolean result = true;
        Collection<?> validReferences = this.getValidReferences(eAnnotation, eModelElement, (Collection<?>)references);
        for (EObject reference : references) {
            if (validReferences.contains(reference)) continue;
            result = false;
            if (diagnostics == null) break;
            this.reportInvalidReference(eAnnotation, eModelElement, reference, diagnostics, context);
        }
        return result;
    }

    protected boolean isReferencesSupported(EAnnotation eAnnotation, EModelElement eModelElement) {
        return false;
    }

    protected Collection<?> getValidReferences(EAnnotation eAnnotation, EModelElement eModelElement, Collection<?> references) {
        return this.isReferencesSupported(eAnnotation, eModelElement) ? references : Collections.emptyList();
    }

    protected boolean validateContents(EAnnotation eAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<EObject> contents = eAnnotation.getContents();
        if (!this.isContentsSupported(eAnnotation, eModelElement)) {
            boolean result = contents.isEmpty();
            if (!result && diagnostics != null) {
                this.reportIgnoredContents(eAnnotation, eModelElement, (Collection<? extends EObject>)contents, diagnostics, context);
            }
            return result;
        }
        boolean result = true;
        Collection<? extends EObject> validContents = this.getValidContents(eAnnotation, eModelElement, (Collection<? extends EObject>)contents);
        for (EObject content : contents) {
            if (validContents.contains(content)) continue;
            result = false;
            if (diagnostics == null) break;
            this.reportInvalidContent(eAnnotation, eModelElement, content, diagnostics, context);
        }
        return result;
    }

    protected boolean isContentsSupported(EAnnotation eAnnotation, EModelElement eModelElement) {
        return false;
    }

    protected Collection<? extends EObject> getValidContents(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EObject> contents) {
        return this.isContentsSupported(eAnnotation, eModelElement) ? contents : Collections.emptyList();
    }

    protected boolean validateAnnotations(EAnnotation eAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<EAnnotation> annotations = eAnnotation.getEAnnotations();
        if (!annotations.isEmpty()) {
            Collection<? extends EAnnotation> validAnnotations = this.getValidAnnotations(eAnnotation, eModelElement, (Collection<? extends EAnnotation>)annotations);
            if (!this.isAnnotationsSupported(eAnnotation, eModelElement)) {
                if (!validAnnotations.containsAll((Collection<?>)annotations)) {
                    if (diagnostics != null) {
                        ArrayList<EAnnotation> ignoredAnnotations = new ArrayList<EAnnotation>((Collection<EAnnotation>)annotations);
                        ignoredAnnotations.removeAll(validAnnotations);
                        this.reportIgnoredAnnotations(eAnnotation, eModelElement, ignoredAnnotations, diagnostics, context);
                    }
                    return false;
                }
                return true;
            }
            boolean result = true;
            for (EAnnotation nestedEAnnotation : annotations) {
                if (validAnnotations.contains(nestedEAnnotation)) continue;
                result = false;
                if (diagnostics == null) break;
                this.reportInvalidAnnotation(eAnnotation, eModelElement, nestedEAnnotation, diagnostics, context);
            }
            return result;
        }
        return true;
    }

    protected boolean isAnnotationsSupported(EAnnotation eAnnotation, EModelElement eModelElement) {
        return false;
    }

    protected Collection<? extends EAnnotation> getValidAnnotations(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EAnnotation> annotations) {
        ArrayList<? extends EAnnotation> result = new ArrayList<EAnnotation>(annotations);
        for (EAnnotation eAnnotation2 : annotations) {
            EAnnotationValidator eAnnotationValidator = EAnnotationValidator.Registry.INSTANCE.getEAnnotationValidator(eAnnotation2.getSource());
            if (eAnnotationValidator instanceof BasicEAnnotationValidator && ((BasicEAnnotationValidator)eAnnotationValidator).isValidLocation(eAnnotation2, eAnnotation)) continue;
            result.remove(eAnnotation2);
        }
        return result;
    }

    protected Collection<? extends EAnnotation> getAllValidAnnotations(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EAnnotation> annotations) {
        ArrayList<? extends EAnnotation> result = new ArrayList<EAnnotation>(this.getValidAnnotations(eAnnotation, eModelElement, annotations));
        for (String annotationSource : EAnnotationValidator.Registry.INSTANCE.keySet()) {
            EAnnotationValidator eAnnotationValidator;
            try {
                eAnnotationValidator = EAnnotationValidator.Registry.INSTANCE.getEAnnotationValidator(annotationSource);
            }
            catch (RuntimeException exception) {
                eAnnotationValidator = null;
                EcorePlugin.INSTANCE.log(exception);
            }
            if (!(eAnnotationValidator instanceof BasicEAnnotationValidator)) continue;
            BasicEAnnotationValidator basicEAnnotationValidator = (BasicEAnnotationValidator)eAnnotationValidator;
            EAnnotation nestedEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            nestedEAnnotation.setSource(annotationSource);
            EAnnotation otherEAnnotation = eAnnotation.getEAnnotation(annotationSource);
            if (otherEAnnotation != null && !basicEAnnotationValidator.isDuplicateValid(eAnnotation, otherEAnnotation, nestedEAnnotation) || !((BasicEAnnotationValidator)eAnnotationValidator).isValidLocation(nestedEAnnotation, eAnnotation)) continue;
            result.add(nestedEAnnotation);
        }
        return result;
    }

    protected boolean validateDetails(EAnnotation eAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        LinkedHashMap<String, EStructuralFeature> properties = new LinkedHashMap<String, EStructuralFeature>(this.getProperties(eModelElement));
        for (Map.Entry<String, String> entry : eAnnotation.getDetails()) {
            String key = (String)entry.getKey();
            EStructuralFeature feature = (EStructuralFeature)properties.remove(key);
            result = feature == null ? (result &= this.validateDetail(eAnnotation, eModelElement, entry, diagnostics, context)) : (result &= this.validateFeatureDetail(eAnnotation, eModelElement, entry, feature, diagnostics, context));
            if (result || diagnostics != null) continue;
            return false;
        }
        if (result) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                EStructuralFeature feature = (EStructuralFeature)entry.getValue();
                if (!feature.isRequired()) continue;
                result = false;
                if (diagnostics == null) break;
                this.reportMissingEntry(eAnnotation, eModelElement, entry.getKey(), feature, diagnostics, context);
            }
        }
        return result;
    }

    protected Map<String, EStructuralFeature> getProperties(EModelElement eModelElement) {
        LinkedHashMap<String, EStructuralFeature> properties = new LinkedHashMap<String, EStructuralFeature>();
        for (EClass eClass : this.getPropertyClasses(eModelElement)) {
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                if (!this.isIncludedProperty(eModelElement, eClass, eStructuralFeature)) continue;
                properties.put(eStructuralFeature.getName(), eStructuralFeature);
            }
        }
        return Collections.unmodifiableMap(properties);
    }

    protected boolean isIncludedProperty(EModelElement eModelElement, EClass eClass, EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected EObject createInstance(EClass eClass, EAnnotation eAnnotation) {
        EModelElement eModelElement = eAnnotation.getEModelElement();
        if (!this.getPropertyClasses(eModelElement).contains(eClass)) {
            throw new IllegalArgumentException("The eClass is not a property class of the model element");
        }
        return this.initialize(EcoreUtil.create(eClass), eAnnotation);
    }

    protected EObject initialize(EObject eObject, EAnnotation eAnnotation) {
        EModelElement eModelElement = eAnnotation.getEModelElement();
        Map<String, EStructuralFeature> properties = this.getProperties(eModelElement);
        for (Map.Entry entry : eAnnotation.getDetails()) {
            String key = (String)entry.getKey();
            EStructuralFeature eStructuralFeature = properties.get(key);
            if (eStructuralFeature instanceof EAttribute) {
                EDataType eDataType = (EDataType)eStructuralFeature.getEType();
                String literalValue = (String)entry.getValue();
                if (eStructuralFeature.isMany()) {
                    List<String> literalValues = this.split(eAnnotation, eModelElement, entry, literalValue, eStructuralFeature, null, null);
                    ArrayList<Object> value = new ArrayList<Object>();
                    if (literalValues != null) {
                        for (String itemLiteralValue : literalValues) {
                            value.add(EcoreUtil.createFromString(eDataType, itemLiteralValue));
                        }
                    }
                    eObject.eSet(eStructuralFeature, value);
                    continue;
                }
                eObject.eSet(eStructuralFeature, EcoreUtil.createFromString(eDataType, literalValue));
                continue;
            }
            if (eStructuralFeature == null) continue;
            throw new UnsupportedOperationException("Initializing of references is not supported");
        }
        return eObject;
    }

    protected String convertPropertyValueToLiteral(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature.isMany()) {
            ArrayList<String> result = new ArrayList<String>();
            if (value != null) {
                List values = (List)value;
                for (Object valueItem : values) {
                    result.add(this.convertPropertyValueToLiteralItem(eObject, eStructuralFeature, valueItem));
                }
            }
            return this.join(eObject, eStructuralFeature, result);
        }
        return this.convertPropertyValueToLiteralItem(eObject, eStructuralFeature, value);
    }

    protected String convertPropertyValueToLiteralItem(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature instanceof EAttribute) {
            return this.convertPropertyAttributeValueToLiteralItem(eObject, (EAttribute)eStructuralFeature, value);
        }
        return this.convertPropertyReferenceValueToLiteralItem(eObject, (EReference)eStructuralFeature, value);
    }

    protected String convertPropertyAttributeValueToLiteralItem(EObject eObject, EAttribute eAttribute, Object value) {
        return EcoreUtil.convertToString(eAttribute.getEAttributeType(), value);
    }

    protected String convertPropertyReferenceValueToLiteralItem(EObject eObject, EReference eReference, Object value) {
        Object name;
        EObject valueEObject;
        EStructuralFeature eStructuralFeature;
        if (value == null) {
            return null;
        }
        if (value instanceof EObject && (eStructuralFeature = (valueEObject = (EObject)value).eClass().getEStructuralFeature("name")) != null && (name = valueEObject.eGet(eStructuralFeature)) instanceof String) {
            return name.toString();
        }
        throw new UnsupportedOperationException("Unable to convert '" + value + "' to a literal value for feature " + eReference + " of " + eObject);
    }

    protected String join(EObject eObject, EStructuralFeature eStructuralFeature, List<String> literalValues) {
        return XMLTypeFactory.eINSTANCE.convertENTITIESBase(literalValues);
    }

    protected boolean isApplicable(EObject eObject, EStructuralFeature eStructuralFeature) {
        return true;
    }

    protected boolean validateDetail(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            this.reportIgnoredEntry(eAnnotation, eModelElement, entry, diagnostics, context);
        }
        return false;
    }

    protected boolean validateFeatureDetail(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        BasicDiagnostic badValueDiagnostic = diagnostics == null ? null : this.createValueDiagnostic(eAnnotation, eModelElement, entry, feature);
        ArrayList<Object> values = new ArrayList<Object>();
        boolean bl = result = feature instanceof EAttribute ? this.validateAttributeDetailLiteralValue(eAnnotation, eModelElement, entry, (EAttribute)feature, values, (DiagnosticChain)badValueDiagnostic, context) : this.validateReferenceDetailLiteralValue(eAnnotation, eModelElement, entry, (EReference)feature, values, (DiagnosticChain)badValueDiagnostic, context);
        if (result) {
            result &= this.validateFeatureDetailValue(eAnnotation, eModelElement, entry, feature, values, (DiagnosticChain)badValueDiagnostic, context);
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)badValueDiagnostic);
        }
        return result;
    }

    protected boolean validateFeatureDetailValue(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        int size = values.size();
        if (feature.isMany()) {
            int upperBound;
            int lowerBound = feature.getLowerBound();
            if (lowerBound > 0 && size < lowerBound) {
                if (diagnostics != null) {
                    this.reportTooFewValues(eAnnotation, eModelElement, entry, feature, values, size, lowerBound, diagnostics, context);
                }
                result = false;
            }
            if ((upperBound = feature.getUpperBound()) > 0 && size > upperBound) {
                if (diagnostics != null) {
                    this.reportTooManyValues(eAnnotation, eModelElement, entry, feature, values, size, upperBound, diagnostics, context);
                }
                result = false;
            }
        } else if (feature.isRequired() && (size == 0 || values.get(0) == null)) {
            result = false;
            if (diagnostics != null) {
                this.reportMissingRequiredEntryValue(eAnnotation, eModelElement, feature, values, diagnostics, context);
            }
        }
        return result;
    }

    protected boolean validateAttributeDetailLiteralValue(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EAttribute attribute, List<Object> dataValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String literalValue = entry.getValue();
        if (attribute.isMany()) {
            List<String> literalValues = this.split(eAnnotation, eModelElement, entry, literalValue, attribute, diagnostics, context);
            if (literalValues != null) {
                for (String literalValueItem : literalValues) {
                    if ((result &= this.validateAttributeDetailValueLiteral(eAnnotation, eModelElement, entry, attribute, literalValueItem, dataValues, diagnostics, context)) || diagnostics != null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = this.validateAttributeDetailValueLiteral(eAnnotation, eModelElement, entry, attribute, literalValue, dataValues, diagnostics, context);
        }
        return result;
    }

    protected boolean validateAttributeDetailValueLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EAttribute attribute, String literalValue, List<Object> dataValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        block5: {
            EDataType dataType = attribute.getEAttributeType();
            try {
                Object value = EcoreUtil.createFromString(dataType, literalValue);
                dataValues.add(value);
                EValidator rootEValidator = this.getRootEValidator(context);
                ValidationContext validationContext = new ValidationContext(eAnnotation, eModelElement, entry, attribute);
                context.put("EANNOTATION_VALIDATION_CONTEXT", validationContext);
                try {
                    result = rootEValidator == null || rootEValidator.validate(dataType, value, diagnostics, context);
                }
                finally {
                    context.remove("EANNOTATION_VALIDATION_CONTEXT");
                }
            }
            catch (RuntimeException exception) {
                result = false;
                if (diagnostics == null) break block5;
                this.reportInvalidValueLiteral(eAnnotation, eModelElement, entry, attribute, literalValue, dataType, diagnostics, exception, context);
            }
        }
        return result;
    }

    protected boolean validateReferenceDetailLiteralValue(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EReference reference, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String literalValue = entry.getValue();
        if (reference.isMany()) {
            List<String> literalValues = this.split(eAnnotation, eModelElement, entry, literalValue, reference, diagnostics, context);
            if (literalValues != null) {
                for (String literalValueItem : literalValues) {
                    if ((result &= this.validateReferenceDetailValueLiteral(eAnnotation, eModelElement, entry, reference, literalValueItem, referenceValues, diagnostics, context)) || diagnostics != null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = this.validateReferenceDetailValueLiteral(eAnnotation, eModelElement, entry, reference, literalValue, referenceValues, diagnostics, context);
        }
        return result;
    }

    protected boolean validateReferenceDetailValueLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EReference reference, String literalValue, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            this.reportInvalidReferenceLiteral(eAnnotation, eModelElement, entry, reference, literalValue, diagnostics, context);
        }
        return false;
    }

    protected List<String> split(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, String literalValue, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return XMLTypeFactory.eINSTANCE.createENTITIESBase(literalValue);
    }

    protected void reportInvalidReferenceLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EReference reference, String literalValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 3, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValue_diagnostic", literalValue, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidReferenceValue_substitution", reference.getEReferenceType().getName())), literalValue, reference.getEReferenceType()));
    }

    protected void reportInvalidValueLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EAttribute attribute, String literalValue, EDataType dataType, DiagnosticChain diagnostics, RuntimeException exception, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 5, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValue_diagnostic", literalValue, exception.getLocalizedMessage()), literalValue, dataType));
    }

    protected void reportMissingRequiredEntryValue(EAnnotation eAnnotation, EModelElement eModelElement, EStructuralFeature feature, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 14, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueRequiredFeatureMustBeSet_diagnostic", new Object[0]), new Object[]{null}));
    }

    protected void reportTooFewValues(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, int size, int lowerBound, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 15, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueFeatureHasTooFewValues_diagnostic", size, lowerBound), values));
    }

    protected void reportTooManyValues(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, int size, int upperBound, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 16, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidValueFeatureHasTooManyValues_diagnostic", size, upperBound), values));
    }

    protected void reportInvalidLocation(EAnnotation eAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 1, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationLocation_diagnostic", this.annotationName, this.getValidLocationDescription()), eAnnotation, EcorePackage.Literals.EANNOTATION__SOURCE));
    }

    protected void reportDuplicate(EAnnotation primaryEAnnotation, EAnnotation secondaryEAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 2, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidDuplicateAnnotation_diagnostic", this.annotationName, this.getValidLocationDescription()), secondaryEAnnotation, EcorePackage.Literals.EANNOTATION__SOURCE, primaryEAnnotation));
    }

    protected void reportIgnoredEntry(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 12, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationEntryKey_diagnostic", this.annotationName, entry.getKey()), entry, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__KEY));
    }

    protected void reportMissingEntry(EAnnotation eAnnotation, EModelElement eModelElement, String key, EStructuralFeature property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 13, this.getString(this.getEcoreResourceLocator(), "_UI_MissingAnnotationEntryKey_diagnostic", key), eAnnotation, EcorePackage.Literals.EANNOTATION__DETAILS));
    }

    protected void reportIgnoredReferences(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EObject> ignoredReferences, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<? extends EObject> data = new ArrayList<EObject>();
        data.add(eAnnotation);
        data.add(EcorePackage.Literals.EANNOTATION__REFERENCES);
        data.addAll(ignoredReferences);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 8, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationReferences_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidReference(EAnnotation eAnnotation, EModelElement eModelElement, EObject reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 9, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationReference_diagnostic", this.annotationName, EObjectValidator.getObjectLabel(reference, context)), eAnnotation, EcorePackage.Literals.EANNOTATION__REFERENCES, reference));
    }

    protected void reportIgnoredContents(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EObject> ignoredContents, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<? extends EObject> data = new ArrayList<EObject>();
        data.add(eAnnotation);
        data.add(EcorePackage.Literals.EANNOTATION__CONTENTS);
        data.addAll(ignoredContents);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 9, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationContents_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidContent(EAnnotation eAnnotation, EModelElement eModelElement, EObject content, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 11, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationContent_diagnostic", this.annotationName, EObjectValidator.getObjectLabel(content, context)), eAnnotation, EcorePackage.Literals.EANNOTATION__CONTENTS, content));
    }

    protected void reportIgnoredAnnotations(EAnnotation eAnnotation, EModelElement eModelElement, Collection<? extends EAnnotation> ignoredAnnotations, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ArrayList<EModelElement> data = new ArrayList<EModelElement>();
        data.add(eAnnotation);
        data.add(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
        data.addAll(ignoredAnnotations);
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 6, this.getString(this.getEcoreResourceLocator(), "_UI_IgnoredAnnotationAnnotations_diagnostic", this.annotationName), data.toArray()));
    }

    protected void reportInvalidAnnotation(EAnnotation eAnnotation, EModelElement eModelElement, EAnnotation nestedEAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(2, 10, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationAnnotation_diagnostic", this.annotationName, EObjectValidator.getObjectLabel(nestedEAnnotation, context)), eAnnotation, EcorePackage.Literals.EANNOTATION__CONTENTS, nestedEAnnotation));
    }

    protected String getValidLocationDescription() {
        String description;
        try {
            description = this.getString(this.getResourceLocator(), "_UI_Valid" + this.annotationName + "AnnotationLocation_substitution", new Object[0]);
        }
        catch (MissingResourceException exception) {
            EcorePlugin.INSTANCE.log(exception);
            description = "unknown; Implementation error for " + this.getClass().getName() + ":" + exception.getLocalizedMessage();
        }
        return description;
    }

    protected BasicDiagnostic createValueDiagnostic(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature) {
        return this.createDiagnostic(0, 4, this.getString(this.getEcoreResourceLocator(), "_UI_InvalidAnnotationEntryValue_diagnostic", this.annotationName, entry.getKey()), entry, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, feature);
    }

    protected ResourceLocator getEcoreResourceLocator() {
        return EcorePlugin.INSTANCE;
    }

    protected BasicDiagnostic createDiagnostic(int severity, int code, String message, Object ... data) {
        return new BasicDiagnostic(severity, this.diagnosticSource, code, message, data);
    }

    protected String getString(ResourceLocator resourceLocator, String key, Object ... substitutions) {
        return substitutions == null ? resourceLocator.getString(key) : resourceLocator.getString(key, substitutions);
    }

    protected EValidator getRootEValidator(Map<Object, Object> context) {
        EValidator result;
        if (context != null && (result = (EValidator)context.get(EValidator.class)) != null) {
            return result;
        }
        return Diagnostician.INSTANCE;
    }

    protected static EPackage loadEPackage(String uri) {
        Resource resource = new EPackageImpl(){

            public Resource createResource(String uri) {
                Resource resource = super.createResource(uri);
                resource.getContents().clear();
                resource.unload();
                return resource;
            }
        }.createResource(uri);
        try {
            resource.load(null);
            EPackage ePackage = (EPackage)EcoreUtil.getObjectByType(resource.getContents(), EcorePackage.Literals.EPACKAGE);
            if (ePackage != null) {
                String nsURI = ePackage.getNsURI();
                EPackage.Registry.INSTANCE.put(nsURI, ePackage);
                resource.setURI(URI.createURI((String)nsURI));
            }
            return ePackage;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Assistant {
        protected final BasicEAnnotationValidator eAnnotationValidator;

        public Assistant(BasicEAnnotationValidator eAnnotationValidator) {
            this.eAnnotationValidator = eAnnotationValidator;
        }

        public boolean isValidLocation(EAnnotation eAnnotation) {
            return this.eAnnotationValidator.isValidLocation(eAnnotation);
        }

        public Map<String, EStructuralFeature> getProperties(EModelElement eModelElement) {
            return this.eAnnotationValidator.getProperties(eModelElement);
        }

        public List<EClass> getPropertyClasses(EModelElement eModelElement) {
            return this.eAnnotationValidator.getPropertyClasses(eModelElement);
        }

        public EObject createInstance(EClass eClass, EAnnotation eAnnotation) {
            return this.eAnnotationValidator.createInstance(eClass, eAnnotation);
        }

        public String convertPropertyValueToLiteral(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
            return this.eAnnotationValidator.convertPropertyValueToLiteral(eObject, eStructuralFeature, value);
        }

        public Map<String, EStructuralFeature> getApplicableProperties(EObject eObject, EAnnotation eAnnotation) {
            EModelElement eModelElement = eAnnotation.getEModelElement();
            Map<String, EStructuralFeature> properties = this.getProperties(eModelElement);
            LinkedHashMap<String, EStructuralFeature> result = new LinkedHashMap<String, EStructuralFeature>();
            for (Map.Entry<String, EStructuralFeature> entry : properties.entrySet()) {
                EStructuralFeature eStructuralFeature = entry.getValue();
                if (!this.eAnnotationValidator.isApplicable(eObject, eStructuralFeature)) continue;
                result.put(entry.getKey(), eStructuralFeature);
            }
            return Collections.unmodifiableMap(result);
        }

        public boolean isReferencesSupported(EAnnotation eAnnotation) {
            return this.eAnnotationValidator.isReferencesSupported(eAnnotation, eAnnotation.getEModelElement());
        }

        public Collection<?> getValidReferences(EAnnotation eAnnotation, Collection<?> references) {
            return this.eAnnotationValidator.getValidReferences(eAnnotation, eAnnotation.getEModelElement(), references);
        }

        public boolean isContentsSupported(EAnnotation eAnnotation) {
            return this.eAnnotationValidator.isContentsSupported(eAnnotation, eAnnotation.getEModelElement());
        }

        public Collection<? extends EObject> getValidContents(EAnnotation eAnnotation, Collection<? extends EObject> contents) {
            return this.eAnnotationValidator.getValidContents(eAnnotation, eAnnotation.getEModelElement(), contents);
        }

        public boolean isAnnotationsSupported(EAnnotation eAnnotation) {
            return this.eAnnotationValidator.isAnnotationsSupported(eAnnotation, eAnnotation.getEModelElement());
        }

        public Collection<? extends EAnnotation> getValidAnnotations(EAnnotation eAnnotation, Collection<? extends EAnnotation> annotations) {
            return this.eAnnotationValidator.getAllValidAnnotations(eAnnotation, eAnnotation.getEModelElement(), annotations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidationContext {
        public static final String CONTEXT_KEY = "EANNOTATION_VALIDATION_CONTEXT";
        private final EAnnotation eAnnotation;
        private final EModelElement eModelElement;
        private final Map.Entry<String, String> entry;
        private final EAttribute eAttribute;

        public ValidationContext(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EAttribute eAttribute) {
            this.eAnnotation = eAnnotation;
            this.eModelElement = eModelElement;
            this.entry = entry;
            this.eAttribute = eAttribute;
        }

        public EAnnotation getEAnnotation() {
            return this.eAnnotation;
        }

        public EModelElement getEModelElement() {
            return this.eModelElement;
        }

        public Map.Entry<String, String> getEntry() {
            return this.entry;
        }

        public EAttribute getEAttribute() {
            return this.eAttribute;
        }
    }
}

