/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.api.tools.internal.AntFilterStore;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.ProblemDetectorBuilder;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.builder.ReferenceAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;

public class UseSearchRequestor
implements IApiSearchRequestor {
    private Set<String> fComponentIds = null;
    private IApiFilterStore currentStore = null;
    private IApiFilterStore antStore = null;
    private String antFilterRoot = null;
    private int fSearchMask = 0;
    private IApiScope fScope = null;
    private String[] jarPatterns = null;
    ReferenceAnalyzer fAnalyzer = null;

    public UseSearchRequestor(Set<String> elementnames, IApiElement[] scope, int searchkinds) {
        this.fSearchMask = searchkinds;
        this.fComponentIds = elementnames;
        this.fAnalyzer = new ReferenceAnalyzer();
        this.prepareScope(scope);
    }

    @Override
    public boolean acceptComponent(IApiComponent component) {
        try {
            if (!component.isSystemComponent() && this.getScope().encloses(component)) {
                if (this.includesIllegalUse()) {
                    this.fAnalyzer.buildProblemDetectors(component, ProblemDetectorBuilder.K_USE, null);
                }
                this.currentStore = component.getFilterStore();
                this.antStore = this.antFilterRoot != null ? new AntFilterStore(this.antFilterRoot, component.getSymbolicName()) : null;
                return true;
            }
        }
        catch (CoreException coreException) {}
        this.currentStore = null;
        return false;
    }

    @Override
    public boolean acceptContainer(IApiTypeContainer container) {
        return this.considerTypeContainer(container);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean acceptMember(IApiMember member) {
        IApiMember iApiMember = member;
        if (iApiMember instanceof IApiType) {
            void type;
            IApiType iApiType = (IApiType)iApiMember;
            IApiType cfr_ignored_0 = (IApiType)iApiMember;
            return !type.isMemberType() && !type.isLocal();
        }
        return true;
    }

    boolean considerTypeContainer(IApiTypeContainer container) {
        if (this.jarPatterns != null && container != null && container.getContainerType() == 1) {
            String[] pparts = null;
            String[] stringArray = this.jarPatterns;
            int n = this.jarPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String jarPattern = stringArray[n2];
                pparts = jarPattern.split(":");
                if (pparts.length == 2 && container.getApiComponent().getSymbolicName().equals(pparts[0]) && container.getName().endsWith(pparts[1])) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public boolean acceptReference(IReference reference, IProgressMonitor monitor) {
        block6: {
            int vis;
            block9: {
                IApiComponent component;
                IApiMember member;
                block8: {
                    block7: {
                        member = reference.getResolvedReference();
                        if (member == null) break block6;
                        component = member.getApiComponent();
                        if (this.fComponentIds.contains(component.getSymbolicName()) && !component.equals(reference.getMember().getApiComponent())) break block7;
                        return false;
                    }
                    if (!this.isIllegalUse(reference, monitor) && (!this.includesAPI() || !this.includesInternal())) break block8;
                    return true;
                }
                IApiAnnotations annots = component.getApiDescription().resolveAnnotations(member.getHandle());
                if (annots == null) break block6;
                vis = annots.getVisibility();
                if (!VisibilityModifiers.isAPI(vis) || !this.includesAPI()) break block9;
                return true;
            }
            try {
                if (VisibilityModifiers.isPrivate(vis) && this.includesInternal()) {
                    return true;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
                AbstractProblemDetector.checkIfDisposed(reference.getMember().getApiComponent(), monitor);
            }
        }
        return false;
    }

    boolean isIllegalUse(IReference reference, IProgressMonitor monitor) {
        IApiProblemDetector[] detectors;
        IApiProblemDetector[] iApiProblemDetectorArray = detectors = this.fAnalyzer.getProblemDetectors(reference.getReferenceKind());
        int n = detectors.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblemDetector detector = iApiProblemDetectorArray[n2];
            if (monitor.isCanceled()) break;
            if (detector.considerReference(reference, monitor)) {
                block5: {
                    Reference ref = (Reference)reference;
                    ref.setFlags(1);
                    try {
                        IApiProblem pb = ((AbstractProblemDetector)detector).checkAndCreateProblem(reference, monitor);
                        if (pb != null && !this.isFiltered(pb)) {
                            ref.addProblems(pb);
                            break block5;
                        }
                        return false;
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                        AbstractProblemDetector.checkIfDisposed(reference.getMember().getApiComponent(), monitor);
                    }
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isFiltered(IApiProblem problem) {
        return this.currentStore != null && this.currentStore.isFiltered(problem) || this.antStore != null && this.antStore.isFiltered(problem);
    }

    @Override
    public int getReferenceKinds() {
        return 0x7BFFFFFF;
    }

    private void prepareScope(IApiElement[] elements) {
        if (elements != null) {
            this.fScope = new ApiScope();
            IApiElement[] iApiElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IApiElement element = iApiElementArray[n2];
                this.fScope.addElement(element.getApiComponent());
                ++n2;
            }
        }
    }

    @Override
    public IApiScope getScope() {
        return this.fScope;
    }

    @Override
    public boolean includesAPI() {
        return (this.fSearchMask & 1) > 0;
    }

    @Override
    public boolean includesInternal() {
        return (this.fSearchMask & 2) > 0;
    }

    @Override
    public boolean includesIllegalUse() {
        return (this.fSearchMask & 4) > 0;
    }

    public void setJarPatterns(String[] patterns) {
        this.jarPatterns = patterns;
    }

    public void setFilterRoot(String filterRoot) {
        this.antFilterRoot = filterRoot;
    }
}

