/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.internal.evaluation.BasicTypeChecker;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedTypeChecker<C, O, P, PM>
extends BasicTypeChecker<C, O, P, PM>
implements TypeChecker.Cached<C, O, P> {
    private boolean bypass = false;
    private final UMLReflection<?, C, O, P, ?, PM, ?, ?, ?, ?> uml;
    private final Map<C, Map<String, Object>> type2name2operationOrOperations = new HashMap<C, Map<String, Object>>();
    private final Map<C, Map<O, O>> type2static2dynamic = new HashMap<C, Map<O, O>>();
    private final Map<C, Map<String, P>> type2name2property = new HashMap<C, Map<String, P>>();

    public CachedTypeChecker(Environment<?, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> environment) {
        super(environment);
        this.uml = environment.getUMLReflection();
    }

    protected boolean exactlyMatches(List<? extends PM> requiredParameters, List<? extends PM> candidateParameters) {
        int iMax = requiredParameters.size();
        if (iMax != candidateParameters.size()) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            C candidateType;
            PM requiredParameter = requiredParameters.get(i);
            PM candidateParameter = candidateParameters.get(i);
            C requiredType = this.uml.getOCLType(requiredParameter);
            if (requiredType != (candidateType = this.uml.getOCLType(candidateParameter))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public P findAttribute(C owner, String name) {
        if (this.bypass) {
            return super.findAttribute(owner, name);
        }
        Map<String, P> name2property = this.getName2Property(owner);
        return name2property.get(name);
    }

    @Override
    protected List<O> getBestMatchingOperations(C owner, String name, List<? extends TypedElement<C>> args) {
        if (this.bypass) {
            return super.getBestMatchingOperations(owner, name, args);
        }
        Map<String, Object> name2operationOrOperations = this.getName2OperationOrOperations(owner);
        Object candidateOperationOrOperations = name2operationOrOperations.get(name);
        if (candidateOperationOrOperations instanceof List) {
            ArrayList matches = null;
            List candidateOperations = (List)candidateOperationOrOperations;
            int bestExactitude = 0;
            for (Object oper : candidateOperations) {
                int exactitude = this.matchArgsWithExactitude(owner, this.uml.getParameters(oper), args);
                if (exactitude < bestExactitude) continue;
                if (exactitude > bestExactitude) {
                    if (matches != null) {
                        matches.clear();
                    }
                    bestExactitude = exactitude;
                }
                if (matches == null) {
                    matches = new ArrayList(3);
                }
                matches.add(oper);
            }
            return matches;
        }
        if (candidateOperationOrOperations != null) {
            Object candidateOperation = candidateOperationOrOperations;
            int exactitude = this.matchArgsWithExactitude(owner, this.uml.getParameters(candidateOperation), args);
            if (exactitude >= 0) {
                return Collections.singletonList(candidateOperation);
            }
            return null;
        }
        return null;
    }

    @Override
    public O getDynamicOperation(C dynamicType, O staticOperation) {
        Map<O, O> typeOperations = this.type2static2dynamic.get(dynamicType);
        if (typeOperations == null) {
            typeOperations = new HashMap<O, O>();
            this.type2static2dynamic.put(dynamicType, typeOperations);
        } else {
            O dynamicOperation = typeOperations.get(staticOperation);
            if (dynamicOperation != null) {
                return dynamicOperation;
            }
            if (typeOperations.containsKey(staticOperation)) {
                return null;
            }
        }
        Map<String, Object> name2operationOrOperations = this.getName2OperationOrOperations(dynamicType);
        O dynamicOperation = this.getExactMatchingOperation(name2operationOrOperations, staticOperation);
        typeOperations.put(staticOperation, dynamicOperation);
        return dynamicOperation;
    }

    protected O getExactMatchingOperation(Map<String, Object> name2operationOrOperations, O operation) {
        String requiredName = this.uml.getName(operation);
        List<PM> requiredParameters = this.uml.getParameters(operation);
        Object candidateOperationOrOperations = name2operationOrOperations.get(requiredName);
        if (candidateOperationOrOperations instanceof List) {
            O matchingOperation = null;
            List candidateOperations = (List)candidateOperationOrOperations;
            for (Object candidateOperation : candidateOperations) {
                List<PM> candidateParameters = this.uml.getParameters(candidateOperation);
                if (!this.exactlyMatches(requiredParameters, candidateParameters)) continue;
                if (matchingOperation == null) {
                    matchingOperation = (O)candidateOperation;
                    continue;
                }
                return null;
            }
            return matchingOperation;
        }
        if (candidateOperationOrOperations != null) {
            Object candidateOperation = candidateOperationOrOperations;
            List<PM> candidateParameters = this.uml.getParameters(candidateOperation);
            if (this.exactlyMatches(requiredParameters, candidateParameters)) {
                return (O)candidateOperation;
            }
            return null;
        }
        return null;
    }

    protected Map<String, Object> getName2OperationOrOperations(C type) {
        Map<String, Object> name2operationOrOperations = this.type2name2operationOrOperations.get(type);
        if (name2operationOrOperations == null) {
            name2operationOrOperations = new HashMap<String, Object>();
            this.type2name2operationOrOperations.put(type, name2operationOrOperations);
            List allOperations = this.getOperations(type);
            for (Object candidateOperation : allOperations) {
                List overloads;
                String name = this.uml.getName(candidateOperation);
                Object overloadOrOverloads = name2operationOrOperations.get(name);
                if (overloadOrOverloads == null) {
                    name2operationOrOperations.put(name, candidateOperation);
                    continue;
                }
                if (overloadOrOverloads instanceof List) {
                    List castOperations = (List)overloadOrOverloads;
                    overloads = castOperations;
                } else {
                    overloads = new ArrayList();
                    name2operationOrOperations.put(name, overloads);
                    Object castOperation = overloadOrOverloads;
                    overloads.add(castOperation);
                }
                C candidateOwner = this.uml.getOwningClassifier(candidateOperation);
                Collection<C> candidateSupertypes = this.uml.getAllSupertypes(candidateOwner);
                List<PM> candidateParameters = this.uml.getParameters(candidateOperation);
                int iMax = candidateParameters.size();
                int j = overloads.size();
                while (--j >= 0) {
                    Object oldOperation = overloads.get(j);
                    List<PM> oldParameters = this.uml.getParameters(oldOperation);
                    if (iMax != oldParameters.size()) continue;
                    int i = 0;
                    while (i < iMax) {
                        C candidateType;
                        PM candidateParameter = candidateParameters.get(i);
                        PM oldParameter = oldParameters.get(i);
                        C oldType = this.uml.getOCLType(oldParameter);
                        if (oldType != (candidateType = this.uml.getOCLType(candidateParameter))) break;
                        ++i;
                    }
                    if (i < iMax) continue;
                    C oldOwner = this.uml.getOwningClassifier(oldOperation);
                    if (candidateSupertypes.contains(oldOwner)) {
                        overloads.remove(j);
                        continue;
                    }
                    Collection<C> oldSupertypes = this.uml.getAllSupertypes(oldOwner);
                    if (oldSupertypes.contains(candidateOwner)) break;
                }
                if (j >= 0) continue;
                overloads.add(candidateOperation);
            }
        }
        return name2operationOrOperations;
    }

    protected Map<String, P> getName2Property(C type) {
        Map<String, P> name2property = this.type2name2property.get(type);
        if (name2property == null) {
            name2property = new HashMap<String, P>();
            this.type2name2property.put(type, name2property);
            List allProperties = this.getAttributes(type);
            for (Object candidateProperty : allProperties) {
                C oldOwner;
                String name = this.uml.getName(candidateProperty);
                P oldProperty = name2property.get(name);
                if (oldProperty == null) {
                    name2property.put(name, candidateProperty);
                    continue;
                }
                C candidateOwner = this.uml.getOwningClassifier(candidateProperty);
                Collection<C> candidateSupertypes = this.uml.getAllSupertypes(candidateOwner);
                if (candidateSupertypes.contains(oldOwner = this.uml.getOwningClassifier(oldProperty))) {
                    name2property.put(name, candidateProperty);
                    continue;
                }
                Collection<C> oldSupertypes = this.uml.getAllSupertypes(oldOwner);
                if (oldSupertypes.contains(candidateOwner)) continue;
            }
        }
        return name2property;
    }

    @Override
    public void reset() {
        this.type2name2operationOrOperations.clear();
        this.type2static2dynamic.clear();
        this.type2name2property.clear();
    }

    @Override
    public void setBypass(boolean bypass) {
        this.reset();
        this.bypass = bypass;
    }
}

