/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.generatedfile.ClasspathUtil;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class GeneratedSourceFolderManager {
    private final AptProject _aptProject;
    private volatile IFolder _generatedSourceFolder;
    private final boolean _isTestCode;
    private volatile boolean _aptEnabled;

    public GeneratedSourceFolderManager(AptProject aptProject, boolean isTestCode) {
        IFolder folder;
        this._aptProject = aptProject;
        this._isTestCode = isTestCode;
        IJavaProject javaProject = aptProject.getJavaProject();
        this._aptEnabled = AptConfig.isEnabled(javaProject);
        if (this._aptEnabled && (folder = this.getFolder()).exists() && this.isOnClasspath(folder)) {
            this._generatedSourceFolder = folder;
        }
    }

    private boolean addToClasspath(IFolder srcFolder, IPath specificOutputLocation) {
        boolean onClasspath = false;
        try {
            ClasspathUtil.updateProjectClasspath(this._aptProject.getJavaProject(), srcFolder, null, this._isTestCode, specificOutputLocation);
            if (AptPlugin.DEBUG) {
                AptPlugin.trace("Ensured classpath has an entry for " + String.valueOf(srcFolder));
            }
            onClasspath = true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            AptPlugin.log(e, "Failed to add classpath entry for generated source folder " + srcFolder.getName());
        }
        return onClasspath;
    }

    private void configure() {
        IFolder sourceFolder = this._generatedSourceFolder;
        IFolder srcFolder = this.getFolderPreference();
        boolean same = Objects.equals(sourceFolder, srcFolder);
        assert (sourceFolder == null || same) : "Should have already removed old folder by now: " + String.valueOf(sourceFolder);
        if (srcFolder == null) {
            Status status = AptPlugin.createStatus(null, "Could not create generated source folder (" + AptConfig.getGenSrcDir(this._aptProject.getJavaProject()) + ")");
            AptPlugin.log((IStatus)status);
            return;
        }
        this.ensureFolderExists(srcFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFolderExists(IFolder srcFolder) {
        IPath specificOutputLocation;
        if (this._isTestCode) {
            IClasspathEntry[] cp;
            try {
                cp = this._aptProject.getJavaProject().getRawClasspath();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            specificOutputLocation = ClasspathUtil.findTestOutputLocation(cp);
            if (specificOutputLocation == null) {
                return;
            }
        } else {
            specificOutputLocation = null;
        }
        if (this.createOnDisk(srcFolder) && this.addToClasspath(srcFolder, specificOutputLocation)) {
            GeneratedSourceFolderManager generatedSourceFolderManager = this;
            synchronized (generatedSourceFolderManager) {
                this._generatedSourceFolder = srcFolder;
            }
        }
    }

    public void ensureFolderExists() {
        if (!this._aptEnabled) {
            return;
        }
        IFolder srcFolder = this.getFolder();
        if (srcFolder == null) {
            Status status = AptPlugin.createStatus(null, "Could not create generated source folder (" + AptConfig.getGenSrcDir(this._aptProject.getJavaProject()) + ")");
            AptPlugin.log((IStatus)status);
            return;
        }
        this.ensureFolderExists(srcFolder);
    }

    private boolean createOnDisk(IFolder srcFolder) {
        boolean exists = false;
        try {
            srcFolder.refreshLocal(2, null);
            if (!srcFolder.exists()) {
                FileSystemUtil.makeDerivedParentFolders((IContainer)srcFolder);
                if (AptPlugin.DEBUG) {
                    AptPlugin.trace("Created folder " + String.valueOf(srcFolder) + " on disk");
                }
            }
            exists = true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            AptPlugin.log(e, "Failed to ensure existence of generated source folder " + srcFolder.getName());
        }
        return exists;
    }

    public void enabledPreferenceChanged() {
        boolean enable = AptConfig.isEnabled(this._aptProject.getJavaProject());
        if (enable == this._aptEnabled) {
            if (AptPlugin.DEBUG) {
                AptPlugin.trace("enabledChanged() doing nothing; state is already " + enable);
            }
            return;
        }
        this.enabledPreferenceChangedTo(enable);
    }

    private void enabledPreferenceChangedTo(boolean enable) {
        this._aptEnabled = enable;
        if (AptPlugin.DEBUG) {
            AptPlugin.trace("enabledChanged() changing state to " + enable + " for " + this._aptProject.getJavaProject().getElementName());
        }
        if (enable) {
            this.configure();
        } else {
            this.removeFolder(false);
        }
    }

    public void folderNamePreferenceChanged() {
        if (!this._aptEnabled) {
            return;
        }
        if (this._generatedSourceFolder != null && this._generatedSourceFolder.equals((Object)this.getFolderPreference())) {
            if (AptPlugin.DEBUG) {
                AptPlugin.trace("folderNameChanged() doing nothing; name is already " + String.valueOf(this._generatedSourceFolder.getProjectRelativePath()));
            }
            return;
        }
        this.removeFolder(true);
        this.configure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void folderDeleted() {
        IFolder srcFolder;
        this._aptProject.projectClean(false, !this._isTestCode, this._isTestCode);
        GeneratedSourceFolderManager generatedSourceFolderManager = this;
        synchronized (generatedSourceFolderManager) {
            srcFolder = this._generatedSourceFolder;
            this._generatedSourceFolder = null;
        }
        if (AptPlugin.DEBUG) {
            AptPlugin.trace("set _generatedSourceFolder to null; was " + String.valueOf(srcFolder));
        }
    }

    public IPath getBinaryOutputLocation() throws JavaModelException {
        IClasspathEntry cpe;
        IPath outputRootPath = null;
        IFolder generatedSourceFolder = this.getFolder();
        if (generatedSourceFolder != null && generatedSourceFolder.exists() && (cpe = ClasspathUtil.findProjectSourcePath(this._aptProject.getJavaProject(), generatedSourceFolder)) != null) {
            outputRootPath = cpe.getOutputLocation();
        }
        if (outputRootPath == null) {
            outputRootPath = this._aptProject.getJavaProject().getOutputLocation();
        }
        int segments = outputRootPath.matchingFirstSegments(this._aptProject.getJavaProject().getPath());
        outputRootPath = outputRootPath.removeFirstSegments(segments);
        return outputRootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFolder getFolder() {
        GeneratedSourceFolderManager generatedSourceFolderManager = this;
        synchronized (generatedSourceFolderManager) {
            if (this._generatedSourceFolder != null) {
                return this._generatedSourceFolder;
            }
        }
        return this.getFolderPreference();
    }

    private IFolder getFolderPreference() {
        String folderName = this._isTestCode ? AptConfig.getGenTestSrcDir(this._aptProject.getJavaProject()) : AptConfig.getGenSrcDir(this._aptProject.getJavaProject());
        IFolder folder = null;
        try {
            folder = this._aptProject.getJavaProject().getProject().getFolder(folderName);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return folder;
    }

    public boolean isGeneratedSourceFolder(IFolder folder) {
        return folder != null && folder.equals((Object)this.getFolder());
    }

    private boolean isOnClasspath(IFolder srcFolder) {
        boolean found = false;
        try {
            if (ClasspathUtil.doesClasspathContainEntry(this._aptProject.getJavaProject(), null, srcFolder.getFullPath(), null)) {
                found = true;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFolder(boolean waitForWorkspaceEvents) {
        final IFolder srcFolder = this._generatedSourceFolder;
        if (srcFolder == null) {
            return;
        }
        this._aptProject.projectClean(false, !this._isTestCode, this._isTestCode);
        try {
            if (srcFolder.isDerived()) {
                ClasspathUtil.removeFromProjectClasspath(this._aptProject.getJavaProject(), srcFolder, null);
            }
        }
        catch (JavaModelException e) {
            AptPlugin.log(e, "Failed to remove classpath entry for old generated src folder " + srcFolder.getName());
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                block5: {
                    try {
                        IContainer parent = srcFolder.getParent();
                        boolean deleted = FileSystemUtil.deleteDerivedResources((IResource)srcFolder);
                        if (!deleted) break block5;
                        while (parent.isDerived() && parent.getType() == 2) {
                            IFolder parentFolder = (IFolder)parent;
                            if (parentFolder.members().length == 0) {
                                parent = parentFolder.getParent();
                                FileSystemUtil.deleteDerivedResources((IResource)parentFolder);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (CoreException e) {
                        AptPlugin.log(e, "failed to delete old generated source folder " + srcFolder.getName());
                    }
                    catch (OperationCanceledException cancel) {
                        AptPlugin.log(cancel, "deletion of generated source folder got cancelled");
                    }
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            ws.run(runnable, (ISchedulingRule)ws.getRoot(), 1, null);
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Runnable for deleting old generated source folder " + srcFolder.getName() + " failed.");
        }
        if (waitForWorkspaceEvents) {
            try {
                Thread.sleep(50L);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
            catch (InterruptedException | OperationCanceledException throwable) {}
        }
        GeneratedSourceFolderManager generatedSourceFolderManager = this;
        synchronized (generatedSourceFolderManager) {
            if (srcFolder.equals((Object)this._generatedSourceFolder)) {
                this._generatedSourceFolder = null;
            }
        }
    }

    public static boolean validate(IJavaProject jproj, String folderName) {
        boolean succeeded;
        block4: {
            IPath combined;
            IWorkspaceRoot root;
            block5: {
                succeeded = false;
                try {
                    Path proposed;
                    if (jproj != null) {
                        IFolder folder = null;
                        folder = jproj.getProject().getFolder(folderName);
                        succeeded = folder != null;
                        break block4;
                    }
                    root = ResourcesPlugin.getWorkspace().getRoot();
                    IPath state = AptPlugin.getPlugin().getStateLocation();
                    combined = state.append((IPath)(proposed = new Path(folderName)));
                    if (combined.segmentCount() > state.segmentCount()) break block5;
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            IFolder folder = root.getFolder(combined);
            succeeded = folder != null;
        }
        return succeeded;
    }

    public boolean isTestCode() {
        return this._isTestCode;
    }
}

