/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efbt.regdna.dsl.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.efbt.regdna.dsl.services.RegdnaGrammarAccess;
import org.eclipse.efbt.regdna.model.regdna.ELClass;
import org.eclipse.efbt.regdna.model.regdna.ELOperation;
import org.eclipse.efbt.regdna.model.regdna.ELStructuralFeature;
import org.eclipse.efbt.regdna.model.regdna.GenerationRulesModule;
import org.eclipse.efbt.regdna.model.regdna.Import;
import org.eclipse.efbt.regdna.model.regdna.RulesForReport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public class RegdnaFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private RegdnaGrammarAccess _regdnaGrammarAccess;

    protected void _format(GenerationRulesModule generationRulesModule, @Extension IFormattableDocument document) {
        EList _imports = generationRulesModule.getImports();
        for (Import _import : _imports) {
            document.format((Object)_import);
        }
        EList _rulesForReport = generationRulesModule.getRulesForReport();
        for (RulesForReport rulesForReport : _rulesForReport) {
            document.format((Object)rulesForReport);
        }
    }

    protected void _format(ELClass eLClass, @Extension IFormattableDocument document) {
        EList _eStructuralFeatures = eLClass.getEStructuralFeatures();
        for (ELStructuralFeature eLStructuralFeature : _eStructuralFeatures) {
            document.format((Object)eLStructuralFeature);
        }
        EList _eOperations = eLClass.getEOperations();
        for (ELOperation eLOperation : _eOperations) {
            document.format((Object)eLOperation);
        }
    }

    public void format(Object eLClass, IFormattableDocument document) {
        if (eLClass instanceof ELClass) {
            this._format((ELClass)eLClass, document);
            return;
        }
        if (eLClass instanceof XtextResource) {
            this._format((XtextResource)eLClass, document);
            return;
        }
        if (eLClass instanceof GenerationRulesModule) {
            this._format((GenerationRulesModule)eLClass, document);
            return;
        }
        if (eLClass instanceof EObject) {
            this._format((EObject)eLClass, document);
            return;
        }
        if (eLClass == null) {
            this._format(null, document);
            return;
        }
        if (eLClass != null) {
            this._format(eLClass, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(eLClass, document).toString());
    }
}

