/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.temporal;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "SCHEMAGENSIMPLE")
public class Simple implements java.io.Serializable {

    int id;
    Date utilDate;

    public Simple() {
    }

    public Simple(int id) {
        this.id = id;
    }
    public Simple(int id, Date utilDate) {
        this.id = id;
        this.utilDate = utilDate;
    }

    @Id
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Temporal(TemporalType.DATE)
    public Date getUtilDate() {
        return utilDate;
    }

    public void setUtilDate(Date utilDate){
        this.utilDate=utilDate;
    }

    public int hashCode() {
        int myHash;

        myHash = this.getId() + this.getUtilDate().hashCode();

        return myHash;
    }
     @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Simple)) return false;

        Simple o1 = (Simple) o;

        boolean result = false;

        if (this.getId() == o1.getId() &&
                (this.getUtilDate() != null && o1.getUtilDate() != null &&
                this.getUtilDate().equals(o1.getUtilDate()))
                ) {
            result = true;
        }

        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", date " + getUtilDate());
        result.append("]");
        return result.toString();
    }

}
