/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.se.cache.inherit;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

/*
 * SoftwareProduct
 */


@Entity
@Cacheable(false)
@DiscriminatorValue("SW")
public class SoftwareProduct extends Product
        implements java.io.Serializable {

    // Instance variables
    private double revisionNumber;

    public SoftwareProduct() {
        super();
    }


    // ===========================================================
    // getters and setters for the state fields


    @Column(name = "REV", nullable = true)
    public double getRevisionNumber() {
        return revisionNumber;
    }

    public void setRevisionNumber(double revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", revisionNumber: " + getRevisionNumber());
        result.append(", quantity: " + getQuantity());
        result.append("]");
        return result.toString();
    }
}
