package com.sun.ts.tests.jpa.core.override.util;

import java.util.HashMap;
import java.util.Map;

public class CallBackCounts {

    private static Map<String, Integer> counts = new HashMap<String, Integer>();

    public CallBackCounts() {
    }

    public static void updateCount(String callBackKeyName) {
        if (counts.containsKey(callBackKeyName)) {
            int currentCallBackCount = counts.get(callBackKeyName);
            System.out.println("callback key name is " + currentCallBackCount);
            counts.put(callBackKeyName, ++currentCallBackCount);
        } else {
            counts.put(callBackKeyName, 1);
        }

    }

    public static int getCount(String callBackKeyName) {
        Integer count = counts.get(callBackKeyName);
        return count == null ? 0 : count;
    }

    public static Map getCallBackCounts() {
        return counts;
    }

    public static void clearCountsMap() {
        counts.clear();
    }
}
