/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex6a;

import javax.persistence.*;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
@IdClass(DID6PersonId.class)
public class DID6MedicalHistory implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @OneToOne
    @JoinColumns({
      @JoinColumn(name="FIRSTNAME", referencedColumnName="FIRSTNAME"),
      @JoinColumn(name="LASTNAME", referencedColumnName="LASTNAME")
    })
    private DID6Person patient;
    private String doctorName;

    public DID6MedicalHistory() {
    }

    public DID6MedicalHistory(DID6Person patient, String doctorName) {
        this.patient = patient;
        this.doctorName = doctorName;
    }

    public DID6Person getPatient() {
        return patient;
    }

    public void setPatient(DID6Person patient) {
        this.patient = patient;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (patient != null ? patient.hashCode() : 0);
        return hash;
    }

    public String getDoctorName() {
        return doctorName;
    }

    public void setDoctorName(String doctorName) {
        this.doctorName = doctorName;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID6MedicalHistory)) {
            return false;
        }
        DID6MedicalHistory other = (DID6MedicalHistory) object;
        if ((this.patient == null && other.patient != null) || (this.patient != null && !this.patient.equals(other.patient))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "derivedpatient5.DID5MedicalHistory[patient=" + patient + "]";
    }
}
