/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.annotations.ordercolumn;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import java.util.List;

@Entity
public class Student implements java.io.Serializable{
    @Id
    int id;
    
    String studentName;

    @ManyToMany(mappedBy = "students", cascade=CascadeType.ALL)
    List<Course> courses;

    public Student(){
    }
    
    public Student(int id){
        this.id=id;
    }

    public Student (int id, String name){
       this.id = id;
       this.studentName= name;
    }
   
    public List<Course> getCourses() {
        return courses;
    }
    
     public void setCourses(List<Course> courses) {
        this.courses = courses;
    }
    
    public int getId() {
        return id;
    }

    public void setId(int studentId) {
        this.id = studentId;
    }

    public String getStudentName() {
        return studentName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }
    
    public int hashCode() {
        
        return this.id;
    }
    
    public boolean equals(Object obj){
        boolean result=false;
        
        if((obj != null) && (obj instanceof Student)){
            Student student = (Student) obj;
            result = (student.id == this.id);
        }
        return result;
    }

}
