/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "DATATYPES")
public class PropertyIntegerId implements java.io.Serializable {

    // ===========================================================
    // instance variables

    protected Integer id;

    private Integer integerData;

    // ===========================================================
    // constructors
    public PropertyIntegerId() {
    }

    public PropertyIntegerId(Integer id, Integer integerData) {

        this.id = id;
        this.integerData = integerData;

    }

    @Id
    @Column(name = "ID")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "INTDATA")
    public Integer getIntegerData() {
        return integerData;
    }

    public void setIntegerData(Integer integerData) {
        this.integerData = integerData;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         result.append(", integer: " + getIntegerData());
         result.append("]");
         return result.toString();
     }
}
