/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.exceptionmapper;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;

@Path("resource")
public class Resource {

	@Path("throwable")
	@GET
	public String throwable() throws Throwable {
		throw new Throwable(new RuntimeException(new ClientErrorException(499)));
	}

	@Path("exception")
	@GET
	public String exception() throws Exception {
		throw new Exception(new RuntimeException(new ClientErrorException(499)));
	}

	@Path("runtime")
	@GET
	public String runtime() {
		throw new RuntimeException(new ClientErrorException(499));
	}
	
	@Path("webapp")
	@GET
	public String webApp(){
		throw new WebApplicationException(new RuntimeException());
	}

	@Path("clienterror")
	@GET
	public String clienterror() {
		throw new ClientErrorException(499, new RuntimeException());
	}
	
	@Path("mapped")
	@GET
	public String mappedException() {
		throw new ExceptionFromMappedException();
	}
	
	@Path("chain")
	@GET
	public String chain() {
		throw new FilterChainTestException();
	}
}
