/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Resource.java 75007 2017-05-30 16:16:39Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.jaxrs21.ee.patch;

import javax.ws.rs.PATCH;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

@Path("resource")
public class Resource {
	public static final long SLEEP_TIME = 1500L;

	@PATCH
	@Path("patch")
	public String patch(String in) {
		return in;
	}

	@PATCH
	@Path("patchnotok")
	public Response patchNotOk(String value) {
		return Response.status(Status.NOT_ACCEPTABLE).build();
	}

	@PATCH
	@Path("patchandwait")
	public String postAndWait(String value) throws InterruptedException {
		Thread.sleep(SLEEP_TIME);
		return value;
	}

}
