/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.resourceinfo;

import java.lang.reflect.Method;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;

@Path("resource")
public class Resource {
	@Context ResourceInfo info;
	
	@GET
	@Path("clazz")
	public String getResourceClass(){
		Class<?> clazz = info.getResourceClass();
		return clazz.getName();
	}
	
	@GET
	@Path("method")
	public String getResourceMethod(){
		Method method = info.getResourceMethod();
		return method.getName();
	}
}
