/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: TemplateFilter.java 69536 2013-01-16 13:41:41Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.illegalstate;

import java.util.Collection;

import javax.ws.rs.container.ContainerRequestContext;

public class TemplateFilter {

	public static final String NOEXCEPTION = "No exception has been thrown";
	public static final String ISEXCEPTION = "IllegalSteateException has been thrown";
	public static final String URI = "http://xx.yy:888/base/resource/sub";
	public static final String OPERATION = "OPERATION";
	
	protected String entity = null;
	protected ContainerRequestContext requestContext;

	protected static <T> String collectionToString(Collection<T> collection) {
		StringBuilder sb = new StringBuilder();
		for (T item : collection) {
			String replace = item.toString().toLowerCase().replace("_", "-")
					.replace(" ", "");
			sb.append(replace).append(" ");
		}
		return sb.toString();
	}

	protected void setEntity(String entity) {
		this.entity = entity;
	}

}
