/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InterceptorBodyTwo.java 69965 2013-02-13 12:02:10Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.interceptor;

import java.io.IOException;
import java.util.Collection;

import javax.ws.rs.ext.InterceptorContext;

import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

public class InterceptorBodyTwo<CONTEXT extends InterceptorContext> extends
		TemplateInterceptorBody<CONTEXT> {

	@Override
	protected Object operationMethodNotFound(String operation)
			throws IOException {
		return proceed();
	}

	public void getPropertyNames() {
		Collection<String> names = context.getPropertyNames();
		setEntity(JaxrsUtil.iterableToString(";", names));
	}

	public void setProperty() {
		Object property = context.getProperty(PROPERTY);
		if (property instanceof StringBuilder)
			setEntity(property.toString());
		else
			setEntity(NULL);
	}
}
