/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.api.rs.core.responseclient;

/**
 * Verification holder structure 
 */
public class VerificationResult {
	public boolean pass;
	public StringBuilder message;
	
	public VerificationResult() {
		pass = true;
		message = new StringBuilder();
	}
	
	public VerificationResult(VerificationResult result){
		this.pass = result.pass;
		this.message = new StringBuilder().append(message);
	}
	
	public VerificationResult append(VerificationResult result) {
		this.pass &= result.pass;
		this.message.append(result.message).append("\n");
		return this;
	}
	
	@Override
	public String toString() {	
		return message.toString();
	}
}
