/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SOAPActionFilter.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2744;

import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SOAPActionFilter implements Filter, SOAPRequests{
    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;

    // remove the filter configuration object for this filter.
    public void destroy() {
    }

    // initialize the filter configuration object for this filter.

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }


    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String result;
     System.out.println("Here in SOAPActionFilter.doFilter()\n");

     if(filterConfig == null) {
            result = "EXCEPTION";
     } else {
        String soapAction = ((HttpServletRequest)request).getHeader("SOAPAction");
        if ("\"foo\"".equals(soapAction)) {
            result = "OK";
        } else {
            result = "FAILED";
        }
     }
        String xml = MessageFormat.format(R2744_RESPONSE, result);
        response.setContentType("text/xml");
        OutputStreamWriter osw = new OutputStreamWriter(response.getOutputStream());
        osw.write(xml);
        osw.flush();
    }    
    
}
