/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62536 2011-04-15 16:35:14Z af70133 $
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * @(#)HelloImpl.java	1.3 03/05/16
 */

package com.sun.ts.tests.jaxrpc.sharedwebservices.hellosecureservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import com.sun.ts.tests.jaxrpc.common.*;

import java.rmi.Remote;
import java.rmi.RemoteException;

import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.rpc.handler.MessageContext;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import java.security.Principal;

// Service Implementation Class - as outlined in JAX-RPC Specification

public class HelloImpl implements Hello, ServiceLifecycle {

    private Object context = null;
    private ServletEndpointContext servletEndpointContext = null;

    public void init(Object context) {
	System.out.println("init called ...");
	this.context = context;
	if (context instanceof ServletEndpointContext)
	    servletEndpointContext = (ServletEndpointContext)context;
    }

    public void destroy() {
	System.out.println("destroy called ...");
    }

    public String hello(String s) throws RemoteException {
        return "Hello, " + s + "!";
    }

    public boolean getHttpSessionTest() throws RemoteException {
	boolean pass = true;
	HttpSession v = null;
	try {
	    if (servletEndpointContext != null) {
		v = servletEndpointContext.getHttpSession();
		System.out.println("HttpSession="+v);
	    }
	}
	catch (Exception e) {
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	return pass;
    }

    public boolean getMessageContextTest() throws RemoteException {
	boolean pass = true;
	MessageContext v = null;
	try {
	    if (servletEndpointContext != null) {
		v = servletEndpointContext.getMessageContext();
		System.out.println("MessageContext="+v);
	    }
	}
	catch (Exception e) {
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	return pass;
    }

    public boolean getServletContextTest() throws RemoteException {
	boolean pass = true;
	ServletContext v = null;
	try {
	    if (servletEndpointContext != null) {
		v = servletEndpointContext.getServletContext();
		System.out.println("ServletContext="+v);
	    }
	}
	catch (Exception e) {
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	return pass;
    }

    public boolean getUserPrincipalTest() throws RemoteException {
	boolean pass = true;
	Principal v = null;
	try {
	    if (servletEndpointContext != null) {
		v = servletEndpointContext.getUserPrincipal();
		System.out.println("UserPrincipal="+v);
	    }
	}
	catch (Exception e) {
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	return pass;
    }

    public boolean isUserInRoleTest(String s) throws RemoteException {
	boolean pass = true;
	boolean v = false;
	try {
	    if (servletEndpointContext != null) {
		v = servletEndpointContext.isUserInRole(s);
		System.out.println("UserInRole("+s+")="+v);
	    }
	}
	catch (Exception e) {
            TestUtil.printStackTrace(e);
	    pass = false;
	}
	return v;
    }
}
