/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;

public abstract class Client {
    private static final String DEFAULT_SCHEME = "http";
    
    private String webServerHost;
    
    private int webServerPort;

    private int mode;

    private TSURL ctsURL;
    
    public Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this.webServerHost = webServerHost;
        this.webServerPort = webServerPort;
	this.mode = mode;
        ctsURL = new TSURL();
    }

    protected String getWebServerHost() {
        return webServerHost;
    }

    protected int getWebServerPort() {
        return webServerPort;
    }

    protected String getScheme(){
        return DEFAULT_SCHEME;
    }

    protected TSURL getCTSURL() {
        return ctsURL;
    }
    
    /**
     * Returns the endpoint URL string.
     *
     * @return the endpoint URL string.
     *
     * @throws java.lang.Exception
     */
    protected String getEndpointURLString() throws EETest.Fault {
	String file = null;
	try {
            file = JAXRPC_Util.getURLFromProp(getEndpointURLProperty());
	}
	catch (Exception e) {
	    throw new EETest.Fault("Unable to obtain endpoint URL string", e);
	}
	String url = null;
	if (file != null) {
	    url = ctsURL.getURLString(getScheme(), getWebServerHost(), getWebServerPort(), file);
	    TestUtil.logMsg("endpoint url=" + url);
	}
	return url;
    }

    protected String getWSDLURLString() throws EETest.Fault {
	String file = null;
	try {
            file = JAXRPC_Util.getURLFromProp(getWSDLURLProperty());
	}
	catch (Exception e) {
	    throw new EETest.Fault("Unable to obtain wsdl URL string", e);
	}
	String url = null;
	if (file != null) {
	    url = ctsURL.getURLString(getScheme(), getWebServerHost(), getWebServerPort(), file);
	    TestUtil.logMsg("wsdl url=" + url);
	}
	return url;
    }

    protected abstract String getEndpointURLProperty();

    protected abstract String getWSDLURLProperty();

}
