/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MyHandlerChainImpl.java 62536 2011-04-15 16:35:14Z af70133 $
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * @(#)MyHandlerChainImpl.java	1.7 03/05/16
 */

package com.sun.ts.tests.jaxrpc.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import java.util.*;
import javax.xml.rpc.*;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.*;
import javax.xml.rpc.handler.*;
import javax.xml.rpc.handler.soap.*;

public class MyHandlerChainImpl extends ArrayList implements HandlerChain
{
    protected List handlerInfos = new ArrayList();
    String[] roles = null;

    public MyHandlerChainImpl(List handlerInfos) {
        this.handlerInfos = handlerInfos;
        createHandlerInstances();
    }

    public MyHandlerChainImpl() {
    }

    private void createHandlerInstances() {
        for(int i = 0; i < handlerInfos.size(); i++)
            add(newHandler(getHandlerInfo(i)));
    }

    public boolean handleFault(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext) _context;

        for(int i = size()-1; i >= 0; i--)
            if (getHandlerInstance(i).handleFault(context) == false)
                return false;
        return true;
    }

    public boolean handleRequest(MessageContext _context) {
        SOAPMessageContext context = (SOAPMessageContext) _context;

        boolean processFault = false;

        for(int i = 0; i < size(); i++) {
            Handler currentHandler = getHandlerInstance(i);
            try {
                if (currentHandler.handleRequest(context) == false) {
                    return false;
                }
            } catch (SOAPFaultException sfe) {
                throw sfe;
            }
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        for(int i = size()-1; i >= 0; i--)
            if (getHandlerInstance(i).handleResponse(context) == false)
                return false;
        return true;
    }

    boolean initialized = false;

    public void init(java.util.Map config) {
        // TODO: How to implement this?
    }

    public void destroy() {
        for(int i = 0; i < size(); i++)
            getHandlerInstance(i).destroy();
        clear();
    }

    Handler getHandlerInstance(int index) {
        return (Handler) castToHandler(get(index));
    }

    HandlerInfo getHandlerInfo(int index) {
        return (HandlerInfo) handlerInfos.get(index);
    }

    Handler newHandler(HandlerInfo handlerInfo) {
        try {
            Handler handler =
		(Handler) handlerInfo.getHandlerClass().newInstance();
            handler.init(handlerInfo);
            return handler;
        } catch (Exception ex) {
              TestUtil.printStackTrace(ex);
            throw new JAXRPCException("Unable to instantiate handler: "+ex);
        }
    }

    public void setRoles(String[] soapActorNames) {
        this.roles = soapActorNames;
    }


    public String[] getRoles() {
        return roles;
    }

    protected Handler castToHandler(Object o) {
        if (!(o instanceof Handler)) {
            throw new JAXRPCException("handler.chain.contains.handler.only"
		+ ": bad object is: " + o.toString());
        }
        return (Handler) o;
    }
}
